/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import com.google.common.base.Strings;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationConfig;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public final class PanelUtil {
    private PanelUtil() {
    }

    public static void renderHead(IHeaderResponse response, Class<?> cls) {
        CssResourceReference cssResourceReference = PanelUtil.cssResourceReferenceFor(cls);
        if (cssResourceReference == null) {
            return;
        }
        CssReferenceHeaderItem forReference = CssHeaderItem.forReference((ResourceReference)cssResourceReference);
        response.render((HeaderItem)forReference);
    }

    public static CssResourceReference cssResourceReferenceFor(Class<?> cls) {
        return PanelUtil.cssResourceReferenceFor(cls, null);
    }

    public static CssResourceReference cssResourceReferenceFor(Class<?> cls, String suffix) {
        String url = PanelUtil.cssFor(cls, suffix);
        if (url == null) {
            return null;
        }
        return new CssResourceReference(cls, url);
    }

    private static String cssFor(Class<?> cls, String suffix) {
        if (cls == null) {
            return null;
        }
        String simpleName = cls.getSimpleName();
        if (Strings.isNullOrEmpty((String)simpleName)) {
            return null;
        }
        String string = suffix != null ? "-" + suffix : "";
        return simpleName + string + ".css";
    }

    public static void disableBeforeReenableOnComplete(AjaxRequestAttributes attributes, Component ajaxButtonOrLink) {
        attributes.getAjaxCallListeners().add(new AjaxCallListener().onBefore((CharSequence)("$('#" + ajaxButtonOrLink.getMarkupId() + "').prop('disabled',true);")).onComplete((CharSequence)("$('#" + ajaxButtonOrLink.getMarkupId() + "').prop('disabled',false);")));
    }

    public static void addConfirmationDialogIfAreYouSureSemantics(Component component, SemanticsOf semanticsOf, ServicesInjector servicesInjector) {
        if (!semanticsOf.isAreYouSure()) {
            return;
        }
        TranslationService translationService = (TranslationService)servicesInjector.lookupService(TranslationService.class);
        ConfirmationConfig confirmationConfig = new ConfirmationConfig();
        String context = IsisSessionFactoryBuilder.class.getName();
        String areYouSure = translationService.translate(context, "Are you sure?");
        String confirm = translationService.translate(context, "Confirm");
        String cancel = translationService.translate(context, "Cancel");
        confirmationConfig.withTitle(areYouSure).withBtnOkLabel(confirm).withBtnCancelLabel(cancel).withPlacement(TooltipConfig.Placement.right).withBtnOkClass("btn btn-danger").withBtnCancelClass("btn btn-default");
        component.add(new Behavior[]{new ConfirmationBehavior(confirmationConfig)});
    }
}

