/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import com.google.inject.Inject;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class PanelAbstract<T extends IModel<?>>
extends Panel {
    private static final long serialVersionUID = 1L;
    private ComponentType componentType;
    @Inject
    WicketViewerSettings settings;

    public PanelAbstract(ComponentType componentType) {
        this(componentType, null);
    }

    public PanelAbstract(String id) {
        this(id, null);
    }

    public PanelAbstract(ComponentType componentType, T model) {
        this(componentType.getWicketId(), model);
    }

    public PanelAbstract(String id, T model) {
        super(id, model);
        this.componentType = ComponentType.lookup(id);
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public T getModel() {
        return (T)this.getDefaultModel();
    }

    protected Component addOrReplace(ComponentType componentType, IModel<?> model) {
        return this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, componentType, model);
    }

    protected void permanentlyHide(ComponentType ... componentIds) {
        Components.permanentlyHide((MarkupContainer)this, componentIds);
    }

    public void permanentlyHide(String ... ids) {
        Components.permanentlyHide((MarkupContainer)this, ids);
    }

    public UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this);
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession();
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((ComponentFactoryRegistryAccessor)this.getApplication()).getComponentFactoryRegistry();
    }

    protected <S> S lookupService(Class<S> serviceClass) {
        return (S)this.getPersistenceSession().getServicesInjector().lookupService(serviceClass);
    }

    protected void addConfirmationDialogIfAreYouSureSemantics(Component component, SemanticsOf semanticsOf) {
        ServicesInjector servicesInjector = this.getPersistenceSession().getServicesInjector();
        PanelUtil.addConfirmationDialogIfAreYouSureSemantics(component, semanticsOf, servicesInjector);
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.getIsisSessionFactory().getDeploymentCategory();
    }

    public PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    protected WicketViewerSettings getSettings() {
        return this.settings;
    }
}

