/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.IFormSubmitterWithPreValidateHook;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.model.IModel;

public abstract class FormAbstract<T>
extends Form<T>
implements ComponentFactoryRegistryAccessor,
PageClassRegistryAccessor {
    private static final long serialVersionUID = 1L;
    private String preValidationErrorIfAny;

    public FormAbstract(String id) {
        super(id);
    }

    public FormAbstract(String id, IModel<T> model) {
        super(id, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(final IFormSubmitter submittingComponent) {
        try {
            if (submittingComponent instanceof IFormSubmitterWithPreValidateHook) {
                IFormSubmitterWithPreValidateHook componentWithPreSubmitHook = (IFormSubmitterWithPreValidateHook)submittingComponent;
                this.preValidationErrorIfAny = componentWithPreSubmitHook.preValidate();
            }
            if (this.preValidationErrorIfAny != null) {
                AdapterManager.ConcurrencyChecking.executeWithConcurrencyCheckingDisabled((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FormAbstract.super.process(submittingComponent);
                    }
                });
            } else {
                super.process(submittingComponent);
            }
        }
        finally {
            this.preValidationErrorIfAny = null;
        }
    }

    @Override
    public ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((ComponentFactoryRegistryAccessor)this.getApplication()).getComponentFactoryRegistry();
    }

    @Override
    public PageClassRegistry getPageClassRegistry() {
        return ((PageClassRegistryAccessor)this.getApplication()).getPageClassRegistry();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession();
    }

    protected DeploymentCategory getDeploymentCategory() {
        return this.getIsisSessionFactory().getDeploymentCategory();
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

