/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.references.BootlintHeaderItem;
import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeCssReference;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.ConfigPropertyEnum;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.hints.IsisEnvelopeEvent;
import org.apache.isis.viewer.wicket.model.hints.IsisEventLetterAbstract;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.DialogMode;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.isis.viewer.wicket.ui.components.actionpromptsb.ActionPromptSidebar;
import org.apache.isis.viewer.wicket.ui.components.widgets.favicon.Favicon;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.isis.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.BootstrapOverridesCssResourceReference;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.SidebarCssResourceReference;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.InspectorDebugPanel;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageAbstract
extends WebPage
implements ActionPromptProvider {
    private static Logger LOG = LoggerFactory.getLogger(PageAbstract.class);
    private static final long serialVersionUID = 1L;
    public static final ConfigPropertyEnum<DialogMode> CONFIG_DIALOG_MODE = new ConfigPropertyEnum("isis.viewer.wicket.dialogMode", (Enum)DialogMode.SIDEBAR);
    private static final JavaScriptResourceReference JQUERY_LIVEQUERY_JS = new JavaScriptResourceReference(PageAbstract.class, "jquery.livequery.js");
    private static final JavaScriptResourceReference JQUERY_ISIS_WICKET_VIEWER_JS = new JavaScriptResourceReference(PageAbstract.class, "jquery.isis.wicket.viewer.js");
    private static final String LIVE_RELOAD_URL_KEY = "isis.viewer.wicket.liveReloadUrl";
    private static final String ID_THEME = "theme";
    private static final String ID_BOOKMARKED_PAGES = "bookmarks";
    private static final String ID_ACTION_PROMPT_MODAL_WINDOW = "actionPromptModalWindow";
    private static final String ID_ACTION_PROMPT_SIDEBAR = "actionPromptSidebar";
    private static final String ID_PAGE_TITLE = "pageTitle";
    private static final String ID_FAVICON = "favicon";
    public static final String ID_MENU_LINK = "menuLink";
    public static final String UIHINT_FOCUS = "focus";
    public static ThreadLocal<ExceptionModel> EXCEPTION = new ThreadLocal();
    private final List<ComponentType> childComponentIds;
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject(optional=true)
    @Named(value="applicationCss")
    private String applicationCss;
    @Inject(optional=true)
    @Named(value="applicationJs")
    private String applicationJs;
    @Inject
    private PageClassRegistry pageClassRegistry;
    protected MarkupContainer themeDiv;
    private ActionPromptModalWindow actionPromptModalWindow;
    private ActionPromptSidebar actionPromptSidebar;

    public PageAbstract(PageParameters pageParameters, String title, ComponentType ... childComponentIds) {
        super(pageParameters);
        try {
            boolean devUtilitiesEnabled;
            this.getSession().bind();
            this.setTitle(title);
            this.add(new Component[]{new Favicon(ID_FAVICON)});
            this.themeDiv = new WebMarkupContainer(ID_THEME);
            this.add(new Component[]{this.themeDiv});
            if (this.applicationName != null) {
                this.themeDiv.add(new Behavior[]{new CssClassAppender(CssClassAppender.asCssStyle(this.applicationName))});
            }
            DebugBar debugBar = (devUtilitiesEnabled = this.getApplication().getDebugSettings().isDevelopmentUtilitiesEnabled()) ? this.newDebugBar("debugBar") : new EmptyPanel("debugBar").setVisible(false);
            this.add(new Component[]{debugBar});
            MarkupContainer header = this.createPageHeader("header");
            this.themeDiv.add(new Component[]{header});
            MarkupContainer footer = this.createPageFooter("footer");
            this.themeDiv.add(new Component[]{footer});
            this.addActionPromptModalWindow(this.themeDiv);
            this.addActionPromptSidebar(this.themeDiv);
            this.childComponentIds = Collections.unmodifiableList(Arrays.asList(childComponentIds));
            this.add(new Component[]{new HeaderResponseContainer("footerJS", "footerJS")});
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to construct page, going back to sign in page", (Throwable)ex);
            List exceptionRecognizers = this.getServicesInjector().lookupServices(ExceptionRecognizer.class);
            String recognizedMessageIfAny = new ExceptionRecognizerComposite(exceptionRecognizers).recognize((Throwable)ex);
            ExceptionModel exceptionModel = ExceptionModel.create(recognizedMessageIfAny, ex);
            this.getSession().invalidate();
            this.getSession().clear();
            EXCEPTION.set(exceptionModel);
            throw new RestartResponseAtInterceptPageException(this.getSignInPage());
        }
    }

    protected DebugBar newDebugBar(String id) {
        DebugBar debugBar = new DebugBar(id);
        List contributors = DebugBar.getContributors((Application)this.getApplication());
        Iterator iterator = contributors.iterator();
        while (iterator.hasNext()) {
            IDebugBarContributor contributor = (IDebugBarContributor)iterator.next();
            if (contributor != InspectorDebugPanel.DEBUG_BAR_CONTRIB) continue;
            iterator.remove();
        }
        return debugBar;
    }

    protected MarkupContainer createPageHeader(String id) {
        Component header = this.getComponentFactoryRegistry().createComponent(ComponentType.HEADER, id, null);
        return (MarkupContainer)header;
    }

    protected MarkupContainer createPageFooter(String id) {
        Component footer = this.getComponentFactoryRegistry().createComponent(ComponentType.FOOTER, id, null);
        return (MarkupContainer)footer;
    }

    protected void setTitle(String title) {
        this.addOrReplace(new Component[]{new Label(ID_PAGE_TITLE, (Serializable)((Object)(title != null ? title : this.applicationName)))});
    }

    private Class<? extends Page> getSignInPage() {
        return this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
    }

    public void renderHead(IHeaderResponse response) {
        Component childComponent;
        String path;
        String liveReloadUrl;
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)this.getApplication().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)FontAwesomeCssReference.instance()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new BootstrapOverridesCssResourceReference()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new SidebarCssResourceReference()));
        this.contributeThemeSpecificOverrides(response);
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JQUERY_LIVEQUERY_JS));
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JQUERY_ISIS_WICKET_VIEWER_JS));
        JGrowlBehaviour jGrowlBehaviour = new JGrowlBehaviour();
        jGrowlBehaviour.renderFeedbackMessages(response);
        if (this.applicationCss != null) {
            response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)this.applicationCss));
        }
        if (this.applicationJs != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.applicationJs));
        }
        if ((liveReloadUrl = this.getConfiguration().getString(LIVE_RELOAD_URL_KEY)) != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)liveReloadUrl));
        }
        if (this.isModernBrowser()) {
            this.addBootLint(response);
        }
        String markupId = null;
        UiHintContainer hintContainer = this.getUiHintContainerIfAny();
        if (hintContainer != null && (path = hintContainer.getHint((Component)this.getPage(), UIHINT_FOCUS)) != null && (childComponent = this.get(path)) != null) {
            markupId = childComponent.getMarkupId();
        }
        String javaScript = markupId != null ? String.format("Wicket.Event.publish(Isis.Topic.FOCUS_FIRST_PROPERTY, '%s')", markupId) : "Wicket.Event.publish(Isis.Topic.FOCUS_FIRST_PROPERTY)";
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)javaScript));
    }

    protected UiHintContainer getUiHintContainerIfAny() {
        return null;
    }

    private void addBootLint(IHeaderResponse response) {
        response.render((HeaderItem)new BootlintHeaderItem("bootlint.showLintReportForCurrentDocument(['E042'], {'problemFree': false});"));
    }

    private boolean isModernBrowser() {
        return !this.isIePre9();
    }

    private boolean isIePre9() {
        WebClientInfo clientInfo = WebSession.get().getClientInfo();
        ClientProperties properties = clientInfo.getProperties();
        return properties.isBrowserInternetExplorer() && properties.getBrowserVersionMajor() < 9;
    }

    private void contributeThemeSpecificOverrides(IHeaderResponse response) {
        IBootstrapSettings bootstrapSettings = Bootstrap.getSettings((Application)this.getApplication());
        ITheme activeTheme = bootstrapSettings.getActiveThemeProvider().getActiveTheme();
        String name = activeTheme.name().toLowerCase(Locale.ENGLISH);
        String themeSpecificOverride = "bootstrap-overrides-" + name + ".css";
        ResourceReference.Key themeSpecificOverrideKey = new ResourceReference.Key(PageAbstract.class.getName(), themeSpecificOverride, null, null, null);
        if (PackageResource.exists((ResourceReference.Key)themeSpecificOverrideKey)) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(themeSpecificOverrideKey)));
        }
    }

    public List<ComponentType> getChildModelTypes() {
        return this.childComponentIds;
    }

    protected void addChildComponents(MarkupContainer container, IModel<?> model) {
        for (ComponentType componentType : this.getChildModelTypes()) {
            this.addComponent(container, componentType, model);
        }
    }

    private void addComponent(MarkupContainer container, ComponentType componentType, IModel<?> model) {
        this.getComponentFactoryRegistry().addOrReplaceComponent(container, componentType, model);
    }

    protected void addBookmarkedPages(MarkupContainer container) {
        boolean showBookmarks = this.isShowBookmarks();
        Component bookmarks = showBookmarks ? this.getComponentFactoryRegistry().createComponent(ComponentType.BOOKMARKED_PAGES, ID_BOOKMARKED_PAGES, (IModel<?>)this.getBookmarkedPagesModel()) : new EmptyPanel(ID_BOOKMARKED_PAGES).setVisible(false);
        container.add(new Component[]{bookmarks});
        bookmarks.add(new Behavior[]{new Behavior(){

            public void onConfigure(Component component) {
                super.onConfigure(component);
                PageParameters parameters = PageAbstract.this.getPageParameters();
                component.setVisible(parameters.get("isis.no.header").isNull());
            }
        }});
    }

    private boolean isShowBookmarks() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.bookmarkedPages.showChooser", true);
    }

    protected boolean isShowBreadcrumbs() {
        return this.getConfiguration().getBoolean("isis.viewer.wicket.breadcrumbs.showChooser", true);
    }

    protected void bookmarkPageIfShown(BookmarkableModel<?> model) {
        if (!this.isShowBookmarks()) {
            return;
        }
        this.getBookmarkedPagesModel().bookmarkPage(model);
    }

    protected void removeAnyBookmark(EntityModel model) {
        this.getBookmarkedPagesModel().remove(model);
    }

    private BookmarkedPagesModel getBookmarkedPagesModel() {
        BookmarkedPagesModelProvider session = (BookmarkedPagesModelProvider)this.getSession();
        return session.getBookmarkedPagesModel();
    }

    public ActionPrompt getActionPrompt() {
        DialogMode dialogMode = (DialogMode)CONFIG_DIALOG_MODE.from(this.getConfiguration());
        switch (dialogMode) {
            case SIDEBAR: {
                return this.actionPromptSidebar;
            }
        }
        return this.actionPromptModalWindow;
    }

    private void addActionPromptModalWindow(MarkupContainer parent) {
        this.actionPromptModalWindow = ActionPromptModalWindow.newModalWindow(ID_ACTION_PROMPT_MODAL_WINDOW);
        parent.addOrReplace(new Component[]{this.actionPromptModalWindow});
    }

    private void addActionPromptSidebar(MarkupContainer parent) {
        this.actionPromptSidebar = ActionPromptSidebar.newSidebar(ID_ACTION_PROMPT_SIDEBAR);
        parent.addOrReplace(new Component[]{this.actionPromptSidebar});
    }

    public void onEvent(IEvent<?> event) {
        Object payload = event.getPayload();
        if (payload instanceof IsisEventLetterAbstract) {
            IsisEventLetterAbstract letter = (IsisEventLetterAbstract)payload;
            IsisEnvelopeEvent broadcastEv = new IsisEnvelopeEvent(letter);
            this.send((IEventSink)this, Broadcast.BREADTH, broadcastEv);
        }
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        ComponentFactoryRegistryAccessor cfra = (ComponentFactoryRegistryAccessor)this.getApplication();
        return cfra.getComponentFactoryRegistry();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    protected IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession();
    }
}

