/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.themepicker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.ActiveThemeProvider;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SessionThemeProvider;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.themes.markup.html.bootstrap.BootstrapThemeTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import de.agilecoders.wicket.themes.markup.html.vegibit.VegibitTheme;
import de.agilecoders.wicket.themes.markup.html.vegibit.VegibitThemeProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeChooser
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(ThemeChooser.class);
    private static final String SHOW_THEME_PICKER_KEY = "isis.viewer.wicket.themes.showChooser";
    private static final boolean SHOW_THEME_PICKER_DEFAULT = false;
    private static final String ENABLED_THEMES_KEY = "isis.viewer.wicket.themes.enabled";
    private static final String ISIS_THEME_COOKIE_NAME = "isis.viewer.wicket.themes.selected";

    public ThemeChooser(String id) {
        super(id);
        ActiveThemeProvider activeThemeProvider = this.getActiveThemeProvider();
        if (activeThemeProvider.getClass() == SessionThemeProvider.class) {
            this.initializeActiveThemeFromCookie();
        }
        ListView<String> themesView = new ListView<String>("themes", this.getThemeNames()){

            protected void populateItem(ListItem<String> item) {
                final String themeName = (String)item.getModelObject();
                if (themeName.equals(ThemeChooser.this.getActiveThemeProvider().getActiveTheme().name())) {
                    item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"active"))});
                }
                item.add(new Component[]{new AjaxLink<Void>("themeLink"){

                    public void onClick(AjaxRequestTarget target) {
                        ThemeChooser.this.setActiveTheme(themeName);
                        ThemeChooser.this.saveActiveThemeToCookie(themeName);
                        target.add(new Component[]{this.getPage()});
                    }
                }.setBody((IModel)Model.of((Serializable)((Object)themeName)))});
            }
        };
        this.add(new Component[]{themesView});
    }

    private void saveActiveThemeToCookie(String themeName) {
        CookieUtils cookieUtils = new CookieUtils();
        cookieUtils.save(ISIS_THEME_COOKIE_NAME, themeName);
    }

    private void initializeActiveThemeFromCookie() {
        CookieUtils cookieUtils = new CookieUtils();
        String activeTheme = cookieUtils.load(ISIS_THEME_COOKIE_NAME);
        if (!Strings.isEmpty((CharSequence)activeTheme)) {
            this.setActiveTheme(activeTheme);
        }
    }

    private void setActiveTheme(String activeTheme) {
        IBootstrapSettings bootstrapSettings = Bootstrap.getSettings();
        ITheme theme = this.getThemeByName(activeTheme);
        this.getActiveThemeProvider().setActiveTheme(theme);
        if (theme instanceof BootstrapThemeTheme) {
            bootstrapSettings.setThemeProvider((ThemeProvider)new SingleThemeProvider(theme));
        } else if (theme instanceof BootswatchTheme) {
            bootstrapSettings.setThemeProvider((ThemeProvider)new BootswatchThemeProvider((BootswatchTheme)theme));
        } else if (theme instanceof VegibitTheme) {
            bootstrapSettings.setThemeProvider((ThemeProvider)new VegibitThemeProvider((VegibitTheme)theme));
        }
    }

    private ITheme getThemeByName(String themeName) {
        Object theme;
        try {
            theme = "bootstrap-theme".equals(themeName) ? new BootstrapThemeTheme() : (themeName.startsWith("veg") ? VegibitTheme.valueOf((String)themeName) : BootswatchTheme.valueOf((String)themeName));
        }
        catch (Exception x) {
            LOG.warn("Cannot find a theme with name '{}' in all available theme providers: {}", (Object)themeName, (Object)x.getMessage());
            theme = new BootstrapThemeTheme();
        }
        return theme;
    }

    private ActiveThemeProvider getActiveThemeProvider() {
        return Bootstrap.getSettings().getActiveThemeProvider();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setName("li");
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"dropdown"});
    }

    private List<String> getThemeNames() {
        BootstrapThemeTheme bootstrapTheme = new BootstrapThemeTheme();
        List<BootswatchTheme> bootswatchThemes = Arrays.asList(BootswatchTheme.values());
        List<String> allThemes = new ArrayList<String>();
        allThemes.add(bootstrapTheme.name());
        for (ITheme iTheme : bootswatchThemes) {
            allThemes.add(iTheme.name());
        }
        allThemes = this.filterThemes(allThemes);
        return allThemes;
    }

    private List<String> filterThemes(List<String> allThemes) {
        ArrayList enabledThemes;
        Object[] enabledThemesArray = this.getConfiguration().getList(ENABLED_THEMES_KEY);
        if (enabledThemesArray.length > 0) {
            final HashSet enabledThemesSet = Sets.newHashSet((Object[])enabledThemesArray);
            Iterable enabled = Iterables.filter(allThemes, (Predicate)new Predicate<String>(){

                public boolean apply(String themeName) {
                    return enabledThemesSet.contains(themeName);
                }
            });
            enabledThemes = Lists.newArrayList((Iterable)enabled);
        } else {
            enabledThemes = allThemes;
        }
        return enabledThemes;
    }

    protected void onConfigure() {
        super.onConfigure();
        boolean shouldShow = this.getConfiguration().getBoolean(SHOW_THEME_PICKER_KEY, false);
        this.setVisible(shouldShow);
    }

    private IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

