/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForChoices;

public class ObjectAdapterMementoProviderForValueChoices
extends ObjectAdapterMementoProviderAbstract
implements ObjectAdapterMementoProviderForChoices {
    private static final long serialVersionUID = 1L;
    private final List<ObjectAdapterMemento> choicesMementos;

    public ObjectAdapterMementoProviderForValueChoices(ScalarModel scalarModel, List<ObjectAdapterMemento> choicesMementos, WicketViewerSettings wicketViewerSettings) {
        super(scalarModel, wicketViewerSettings);
        this.choicesMementos = choicesMementos;
    }

    @Override
    protected List<ObjectAdapterMemento> obtainMementos(String term) {
        return this.obtainMementos(term, this.choicesMementos);
    }

    @Override
    public List<ObjectAdapterMemento> getChoiceMementos() {
        return this.choicesMementos;
    }

    public Collection<ObjectAdapterMemento> toChoices(final Collection<String> ids) {
        List<ObjectAdapterMemento> mementos = this.obtainMementos(null);
        Predicate<ObjectAdapterMemento> lookupOam = new Predicate<ObjectAdapterMemento>(){

            public boolean apply(ObjectAdapterMemento input) {
                String id = ObjectAdapterMementoProviderForValueChoices.this.getIdValue(input);
                return ids.contains(id);
            }
        };
        return Lists.newArrayList((Iterable)FluentIterable.from(mementos).filter((Predicate)lookupOam).toList());
    }
}

