/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderAbstract;

public class ObjectAdapterMementoProviderForReferenceObjectAutoComplete
extends ObjectAdapterMementoProviderAbstract {
    private static final long serialVersionUID = 1L;

    public ObjectAdapterMementoProviderForReferenceObjectAutoComplete(ScalarModel model, WicketViewerSettings wicketViewerSettings) {
        super(model, wicketViewerSettings);
    }

    @Override
    protected List<ObjectAdapterMemento> obtainMementos(String term) {
        ObjectSpecification typeOfSpecification = this.getScalarModel().getTypeOfSpecification();
        AutoCompleteFacet autoCompleteFacet = (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class);
        List autoCompleteAdapters = autoCompleteFacet.execute(term, InteractionInitiatedBy.USER);
        return Lists.newArrayList((Iterable)Lists.transform((List)autoCompleteAdapters, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
    }

    public Collection<ObjectAdapterMemento> toChoices(Collection<String> ids) {
        Function<String, ObjectAdapterMemento> function = new Function<String, ObjectAdapterMemento>(){

            public ObjectAdapterMemento apply(String input) {
                if ("$$_isis_null_$$".equals(input)) {
                    return null;
                }
                RootOid oid = RootOid.deString((String)input);
                ObjectAdapterMemento oam = ObjectAdapterMemento.createPersistent((RootOid)oid);
                return oam;
            }
        };
        return Lists.newArrayList((Iterable)Collections2.transform(ids, (Function)function));
    }
}

