/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.postprocessors.param.ActionParameterDefaultsFacetFromAssociatedCollection;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettingsAccessor;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.InlinePromptContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ToggledMementosProvider;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionFormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionParametersPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;

public abstract class ActionLinkFactoryAbstract
implements ActionLinkFactory {
    private static final long serialVersionUID = 1L;
    protected final EntityModel targetEntityModel;
    private final ScalarModel scalarModelForAssociationIfAny;

    protected ActionLinkFactoryAbstract(EntityModel targetEntityModel, ScalarModel scalarModelForAssociationIfAny) {
        this.targetEntityModel = targetEntityModel;
        this.scalarModelForAssociationIfAny = scalarModelForAssociationIfAny;
    }

    protected ActionLink newLink(String linkId, ObjectAction action, final ToggledMementosProvider toggledMementosProviderIfAny) {
        ActionModel actionModel = ActionModel.create((EntityModel)this.targetEntityModel, (ObjectAction)action);
        ActionLink link = new ActionLink(linkId, actionModel, action){
            private static final long serialVersionUID = 1L;

            @Override
            protected void doOnClick(final AjaxRequestTarget target) {
                if (toggledMementosProviderIfAny != null) {
                    final PersistenceSession persistenceSession = ActionLinkFactoryAbstract.this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
                    final SpecificationLoader specificationLoader = ActionLinkFactoryAbstract.this.getIsisSessionFactory().getSpecificationLoader();
                    List selectedMementos = toggledMementosProviderIfAny.getToggles();
                    ImmutableList selectedPojos = FluentIterable.from((Iterable)selectedMementos).transform((Function)new Function<ObjectAdapterMemento, Object>(){

                        @Nullable
                        public Object apply(@Nullable ObjectAdapterMemento input) {
                            if (input == null) {
                                return null;
                            }
                            ObjectAdapter objectAdapter = input.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, persistenceSession, specificationLoader);
                            return objectAdapter != null ? objectAdapter.getObject() : null;
                        }
                    }).filter(Predicates.notNull()).toList();
                    ActionPrompt actionPrompt = (ActionPrompt)ActionParameterDefaultsFacetFromAssociatedCollection.withSelected((List)selectedPojos, (ActionParameterDefaultsFacetFromAssociatedCollection.SerializableRunnable)new ActionParameterDefaultsFacetFromAssociatedCollection.SerializableRunnable<ActionPrompt>(){

                        public ActionPrompt call() {
                            return this.performOnClick(target);
                        }
                    });
                    if (actionPrompt != null) {
                        actionPrompt.setOnClose(new ActionPrompt.CloseHandler(){

                            public void close(AjaxRequestTarget target) {
                                toggledMementosProviderIfAny.clearToggles(target);
                            }
                        });
                    }
                } else {
                    this.performOnClick(target);
                }
            }

            private ActionPrompt performOnClick(AjaxRequestTarget target) {
                return ActionLinkFactoryAbstract.this.onClick(this, target);
            }
        };
        link.add(new Behavior[]{new CssClassAppender("noVeil")});
        return link;
    }

    private ActionPrompt onClick(ActionLink actionLink, AjaxRequestTarget target) {
        final ActionModel actionModel = actionLink.getActionModel();
        InlinePromptContext inlinePromptContext = this.determineInlinePromptContext();
        PromptStyle promptStyle = actionModel.getPromptStyle();
        if (inlinePromptContext == null || promptStyle.isDialog()) {
            ActionPromptProvider promptProvider = ActionPromptProvider.Util.getFrom((Page)actionLink.getPage());
            ActionPrompt prompt = promptProvider.getActionPrompt();
            if (actionModel.hasParameters()) {
                ActionParametersPanel actionParametersPanel = (ActionParametersPanel)this.getComponentFactoryRegistry().createComponent(ComponentType.ACTION_PROMPT, prompt.getContentId(), (IModel<?>)actionModel);
                actionParametersPanel.setShowHeader(false);
                Label label = new Label(prompt.getTitleId(), (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        ObjectAction action = actionModel.getActionMemento().getAction(ActionLinkFactoryAbstract.this.getSpecificationLoader());
                        return action.getName();
                    }
                });
                prompt.setTitle((Component)label, target);
                prompt.setPanel((Component)actionParametersPanel, target);
                actionParametersPanel.setActionPrompt(prompt);
                prompt.showPrompt(target);
                return prompt;
            }
            FormExecutorDefault<ActionModel> formExecutor = new FormExecutorDefault<ActionModel>(new ActionFormExecutorStrategy(actionModel));
            Page page = actionLink.getPage();
            boolean succeeded = formExecutor.executeAndProcessResults(page, null, null, actionModel.isWithinPrompt());
            if (!succeeded) {
                final ObjectAdapter targetAdapter = actionModel.getTargetAdapter();
                EntityPage entityPage = (EntityPage)((Object)AdapterManager.ConcurrencyChecking.executeWithConcurrencyCheckingDisabled((Callable)new Callable<EntityPage>(){

                    @Override
                    public EntityPage call() throws Exception {
                        return new EntityPage(targetAdapter, null);
                    }
                }));
                this.getIsisSessionFactory().getCurrentSession().getPersistenceSession().getTransactionManager().flushTransaction();
                RequestCycle requestCycle = RequestCycle.get();
                requestCycle.setResponsePage((IRequestablePage)entityPage);
            }
        } else {
            MarkupContainer scalarTypeContainer = inlinePromptContext.getScalarTypeContainer();
            actionModel.setInlinePromptContext(inlinePromptContext);
            this.getComponentFactoryRegistry().addOrReplaceComponent(scalarTypeContainer, "scalarIfRegularInlinePromptForm", ComponentType.PARAMETERS, (IModel<?>)actionModel);
            inlinePromptContext.getScalarIfRegular().setVisible(false);
            inlinePromptContext.getScalarIfRegularInlinePromptForm().setVisible(true);
            target.add(new Component[]{scalarTypeContainer});
        }
        return null;
    }

    protected LinkAndLabel newLinkAndLabel(ObjectAdapter objectAdapter, ObjectAction objectAction, AbstractLink link, String disabledReasonIfAny) {
        boolean whetherReturnsBlobOrClob = ObjectAction.Util.returnsBlobOrClob((ObjectAction)objectAction);
        return LinkAndLabel.newLinkAndLabel((ObjectAdapter)objectAdapter, (ObjectAction)objectAction, (AbstractLink)link, (String)disabledReasonIfAny, (boolean)whetherReturnsBlobOrClob);
    }

    private InlinePromptContext determineInlinePromptContext() {
        return this.scalarModelForAssociationIfAny != null ? this.scalarModelForAssociationIfAny.getInlinePromptContext() : null;
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((ComponentFactoryRegistryAccessor)Application.get()).getComponentFactoryRegistry();
    }

    protected PageClassRegistry getPageClassRegistry() {
        return ((PageClassRegistryAccessor)Application.get()).getPageClassRegistry();
    }

    protected WicketViewerSettings getSettings() {
        return ((WicketViewerSettingsAccessor)Application.get()).getSettings();
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }
}

