/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;
import org.wicketstuff.select2.Select2Choice;
import org.wicketstuff.select2.Settings;

public class BreadcrumbPanel
extends PanelAbstract<IModel<Void>> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BREADCRUMBS = "breadcrumbs";
    public static final String SHOW_BREADCRUMBS_KEY = "isis.viewer.wicket.breadcrumbs.showChooser";
    public static final boolean SHOW_BREADCRUMBS_DEFAULT = true;

    public BreadcrumbPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        final BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        Model entityModel = new Model();
        ChoiceProvider<EntityModel> choiceProvider = new ChoiceProvider<EntityModel>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(EntityModel choice) {
                return this.titleFor(choice);
            }

            private String titleFor(EntityModel model) {
                return model.getObjectAdapterMemento().getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, model.getPersistenceSession(), model.getSpecificationLoader()).titleString(null);
            }

            public String getIdValue(EntityModel choice) {
                try {
                    PageParameters pageParameters = choice.getPageParametersWithoutUiHints();
                    String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
                    RootOid result = RootOid.deString((String)oidStr);
                    return OidMarshaller.INSTANCE.marshal(result);
                }
                catch (Exception ex) {
                    breadcrumbModel.remove(choice);
                    return null;
                }
            }

            public void query(String term, int page, Response<EntityModel> response) {
                ArrayList breadCrumbList = Lists.newArrayList(breadcrumbModel.getList());
                ArrayList checkedList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)breadCrumbList, (Predicate)new Predicate<EntityModel>(){

                    public boolean apply(EntityModel input) {
                        String id = this.getIdValue(input);
                        return id != null;
                    }
                }));
                response.addAll((Collection)checkedList);
            }

            public Collection<EntityModel> toChoices(Collection<String> ids) {
                return breadcrumbModel.getList();
            }
        };
        final Select2Choice breadcrumbChoice = new Select2Choice(ID_BREADCRUMBS, (IModel)entityModel, (ChoiceProvider)choiceProvider);
        breadcrumbChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                String oidStr = breadcrumbChoice.getInput();
                EntityModel selectedModel = breadcrumbModel.lookup(oidStr);
                if (selectedModel == null) {
                    MessageBroker messageBroker = BreadcrumbPanel.this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession().getMessageBroker();
                    messageBroker.addWarning("Cannot find object");
                    String feedbackMsg = JGrowlUtil.asJGrowlCalls(messageBroker);
                    target.appendJavaScript((CharSequence)feedbackMsg);
                    breadcrumbModel.remove(oidStr);
                    return;
                }
                BreadcrumbPanel.this.setResponsePage(EntityPage.class, selectedModel.getPageParametersWithoutUiHints());
            }
        }});
        Settings settings = breadcrumbChoice.getSettings();
        settings.setMinimumInputLength(Integer.valueOf(0));
        settings.setWidth("100%");
        this.addOrReplace(new Component[]{breadcrumbChoice});
    }

    protected void onConfigure() {
        super.onConfigure();
        boolean shouldShow = this.getConfiguration().getBoolean(SHOW_BREADCRUMBS_KEY, true);
        this.setVisible(shouldShow);
    }
}

