/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class BreadcrumbModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SIZE = 5;
    private static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;
    private final Map<String, Bookmark> bookmarkByOidStr = Maps.newHashMap();
    private final Map<Bookmark, String> oidStrByBookmark = Maps.newHashMap();
    private final List<Bookmark> list = Lists.newArrayList();
    private String mostRecentlyVisitedOidStr;

    public List<EntityModel> getList() {
        ArrayList entityModels = Lists.newArrayList();
        for (Bookmark bookmark : this.list) {
            EntityModel entityModel = this.toEntityModel(bookmark);
            entityModels.add(entityModel);
        }
        return Collections.unmodifiableList(entityModels);
    }

    public void visitedHomePage() {
        this.mostRecentlyVisitedOidStr = null;
    }

    public EntityModel getMostRecentlyVisited() {
        return this.mostRecentlyVisitedOidStr != null ? this.lookup(this.mostRecentlyVisitedOidStr) : null;
    }

    public void visited(EntityModel entityModel) {
        String oidStr;
        if (entityModel.getTypeOfSpecification().isViewModel()) {
            this.mostRecentlyVisitedOidStr = null;
            return;
        }
        this.mostRecentlyVisitedOidStr = oidStr = this.oidStrFrom(entityModel);
        this.remove(oidStr);
        this.addToStart(oidStr, entityModel);
        this.trimTo(5);
    }

    private String oidStrFrom(EntityModel entityModel) {
        PageParameters pageParameters = entityModel.getPageParametersWithoutUiHints();
        return this.oidStrFrom(pageParameters);
    }

    private String oidStrFrom(PageParameters pageParameters) {
        String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
        if (oidStr == null) {
            return null;
        }
        try {
            RootOid unmarshal = (RootOid)OID_MARSHALLER.unmarshal(oidStr, RootOid.class);
            return unmarshal.enStringNoVersion();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void addToStart(String oidStr, EntityModel entityModel) {
        Bookmark bookmark = this.toBookmark(entityModel);
        this.bookmarkByOidStr.put(oidStr, bookmark);
        this.oidStrByBookmark.put(bookmark, oidStr);
        this.list.add(0, bookmark);
    }

    private void trimTo(int size) {
        if (this.list.size() <= size) {
            return;
        }
        List<Bookmark> bookmarksToRemove = this.list.subList(size, this.list.size());
        for (Bookmark bookmark : bookmarksToRemove) {
            String oidStr = this.oidStrByBookmark.get(bookmark);
            this.remove(oidStr, bookmark);
        }
    }

    public EntityModel lookup(String oidStr) {
        if (oidStr == null) {
            return null;
        }
        Bookmark bookmark = this.bookmarkByOidStr.get(oidStr);
        if (bookmark == null) {
            return null;
        }
        return this.toEntityModel(bookmark);
    }

    public void detach() {
    }

    void remove(String rootOid) {
        Bookmark existingBookmark = this.bookmarkByOidStr.get(rootOid);
        if (existingBookmark != null) {
            this.remove(rootOid, existingBookmark);
        }
    }

    public void remove(EntityModel entityModel) {
        Bookmark bookmark = this.toBookmark(entityModel);
        String oidStr = this.oidStrByBookmark.get(bookmark);
        if (oidStr != null) {
            this.remove(oidStr, bookmark);
        }
    }

    protected Bookmark toBookmark(EntityModel entityModel) {
        return entityModel.getObjectAdapterMemento().asBookmark();
    }

    protected EntityModel toEntityModel(Bookmark bookmark) {
        RootOid rootOid = RootOid.create((Bookmark)bookmark);
        ObjectAdapterMemento oam = ObjectAdapterMemento.createPersistent((RootOid)rootOid);
        return new EntityModel(oam);
    }

    private void remove(String rootOid, Bookmark bookmark) {
        this.bookmarkByOidStr.remove(rootOid);
        this.oidStrByBookmark.remove(bookmark);
        this.list.remove(bookmark);
    }

    public synchronized void clear() {
        this.bookmarkByOidStr.clear();
        this.oidStrByBookmark.clear();
        this.list.clear();
        this.mostRecentlyVisitedOidStr = null;
    }
}

