/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.valuechoices;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.PanelWithChoices;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelSelect2Abstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForValueChoices;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.select2.AbstractSelect2Choice;
import org.wicketstuff.select2.ChoiceProvider;

public class ValueChoicesSelect2Panel
extends ScalarPanelSelect2Abstract
implements PanelWithChoices {
    private static final long serialVersionUID = 1L;
    @Inject
    WicketViewerSettings wicketViewerSettings;

    public ValueChoicesSelect2Panel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected Component createComponentForCompact() {
        return new Label("scalarIfCompact", (Serializable)((Object)((ScalarModel)this.getModel()).getObjectAsString()));
    }

    @Override
    protected MarkupContainer createComponentForRegular() {
        if (this.select2 == null) {
            this.select2 = this.createSelect2("scalarValue");
        } else {
            this.select2.clearInput();
        }
        AbstractSelect2Choice formComponent = this.select2.component();
        return this.createFormGroup((FormComponent<?>)formComponent);
    }

    private List<ObjectAdapterMemento> getChoiceMementos(ObjectAdapter[] argumentsIfAvailable) {
        List choices = this.scalarModel.getChoices(argumentsIfAvailable, this.getAuthenticationSession(), this.getDeploymentCategory());
        return Lists.newArrayList((Iterable)Lists.transform((List)choices, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
    }

    @Override
    protected ScalarPanelAbstract2.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract2.InlinePromptConfig.supportedAndHide((Component)this.select2.component());
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        ObjectAdapterMemento modelObject = this.select2.getModelObject();
        String str = modelObject != null ? modelObject.asString() : null;
        return Model.of((Serializable)((Object)str));
    }

    @Override
    protected void onInitializeWhenViewMode() {
        this.select2.setEnabled(false);
    }

    @Override
    protected void onInitializeWhenEnabled() {
        this.select2.setEnabled(true);
    }

    @Override
    protected void onInitializeWhenDisabled(String disableReason) {
        super.onInitializeWhenDisabled(disableReason);
        this.setTitleAttribute(disableReason);
        this.select2.setEnabled(false);
    }

    private void setTitleAttribute(String titleAttribute) {
        this.getComponentForRegular().add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)titleAttribute)))});
    }

    @Override
    protected ChoiceProvider<ObjectAdapterMemento> buildChoiceProvider(ObjectAdapter[] argsIfAvailable) {
        List<ObjectAdapterMemento> choicesMementos = this.getChoiceMementos(argsIfAvailable);
        return new ObjectAdapterMementoProviderForValueChoices(this.scalarModel, choicesMementos, this.wicketViewerSettings);
    }

    @Override
    protected void syncIfNull(Select2 select2, List<ObjectAdapterMemento> choicesMementos) {
        ObjectAdapterMemento curr = ((ScalarModel)this.getModel()).getObjectAdapterMemento();
        if (curr == null) {
            select2.getModel().setObject(null);
        }
    }

    public ScalarModel getScalarModel() {
        return this.scalarModel;
    }

    @Override
    protected String getScalarPanelType() {
        return "valueChoicesSelect2Panel";
    }
}

