/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.uuid;

import com.google.common.base.Strings;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;

public class UuidConverter
implements IConverter<UUID> {
    private static final Pattern pattern = Pattern.compile("[0-9a-fA-F]{8}(?:-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}");

    public UUID convertToObject(String value, Locale locale) throws ConversionException {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw this.newConversionException(value);
        }
    }

    public String convertToString(UUID value, Locale locale) {
        return value != null ? value.toString() : null;
    }

    private ConversionException newConversionException(String value) {
        return new ConversionException(String.format("Failed to convert '%s' to a UUID", value));
    }
}

