/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.reference;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.EntityModelForReference;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.scalars.PanelWithChoices;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelSelect2Abstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.reference.EntityLinkSelect2Panel;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.components.widgets.entitysimplelink.EntityLinkSimplePanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForReferenceChoices;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForReferenceObjectAutoComplete;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForReferenceParamOrPropertyAutoComplete;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Settings;

public class ReferencePanel
extends ScalarPanelSelect2Abstract
implements PanelWithChoices {
    private static final long serialVersionUID = 1L;
    private static final String ID_AUTO_COMPLETE = "autoComplete";
    private static final String ID_ENTITY_ICON_TITLE = "entityIconAndTitle";
    private static final String KEY_DISABLE_DEPENDENT_CHOICE_AUTO_SELECTION = "isis.viewer.wicket.disableDependentChoiceAutoSelection";
    private EntityLinkSelect2Panel entityLink;
    private EntityLinkSimplePanel entitySimpleLink;
    @Inject
    WicketViewerSettings wicketViewerSettings;

    public ReferencePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    Select2 getSelect2() {
        return this.select2;
    }

    @Override
    protected Component createComponentForCompact() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        String name = scalarModel.getName();
        this.entitySimpleLink = (EntityLinkSimplePanel)this.getComponentFactoryRegistry().createComponent(ComponentType.ENTITY_LINK, (IModel<?>)this.getModel());
        this.entitySimpleLink.setOutputMarkupId(true);
        this.entitySimpleLink.setLabel((IModel)Model.of((Serializable)((Object)name)));
        WebMarkupContainer labelIfCompact = new WebMarkupContainer("scalarIfCompact");
        labelIfCompact.add(new Component[]{this.entitySimpleLink});
        return labelIfCompact;
    }

    protected FormGroup createComponentForRegular() {
        this.entityLink = new EntityLinkSelect2Panel(ComponentType.ENTITY_LINK.getWicketId(), this);
        this.entityLink.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.select2 = this.createSelect2AndSemantics();
        this.entityLink.addOrReplace(new Component[]{this.select2.component()});
        this.syncWithInput();
        this.entityLink.setOutputMarkupId(true);
        EntityLinkSelect2Panel formComponent = this.entityLink;
        return this.createFormGroup((FormComponent<?>)formComponent);
    }

    private Select2 createSelect2AndSemantics() {
        Select2 select2 = this.createSelect2(ID_AUTO_COMPLETE);
        Settings settings = select2.getSettings();
        if (((ScalarModel)this.getModel()).hasChoices()) {
            settings.setPlaceholder((Object)((ScalarModel)this.getModel()).getName());
        } else if (((ScalarModel)this.getModel()).hasAutoComplete()) {
            int minLength = ((ScalarModel)this.getModel()).getAutoCompleteMinLength();
            settings.setMinimumInputLength(Integer.valueOf(minLength));
            settings.setPlaceholder((Object)((ScalarModel)this.getModel()).getName());
        } else if (this.hasObjectAutoComplete()) {
            ObjectSpecification typeOfSpecification = ((ScalarModel)this.getModel()).getTypeOfSpecification();
            AutoCompleteFacet autoCompleteFacet = (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class);
            int minLength = autoCompleteFacet.getMinLength();
            settings.setMinimumInputLength(Integer.valueOf(minLength));
        }
        return select2;
    }

    @Override
    protected ScalarPanelAbstract2.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract2.InlinePromptConfig.supportedAndHide((Component)this.select2.component());
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        final IModel<ObjectAdapterMemento> model = this.select2.getModel();
        return new IModel<String>(){

            public String getObject() {
                ObjectAdapterMemento oam = (ObjectAdapterMemento)model.getObject();
                if (oam == null) {
                    return null;
                }
                ObjectAdapter objectAdapter = oam.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, ReferencePanel.this.getPersistenceSession(), ReferencePanel.this.getSpecificationLoader());
                return objectAdapter != null ? objectAdapter.titleString(null) : null;
            }

            public void setObject(String s) {
            }

            public void detach() {
            }
        };
    }

    @Override
    protected void onInitializeWhenEnabled() {
        super.onInitializeWhenEnabled();
        this.entityLink.setEnabled(true);
        this.syncWithInput();
    }

    @Override
    protected void onInitializeWhenViewMode() {
        super.onInitializeWhenViewMode();
        this.entityLink.setEnabled(false);
        this.syncWithInput();
    }

    @Override
    protected void onInitializeWhenDisabled(String disableReason) {
        super.onInitializeWhenDisabled(disableReason);
        this.syncWithInput();
        EntityModel entityLinkModel = (EntityModel)this.entityLink.getModel();
        entityLinkModel.toViewMode();
        this.entityLink.setEnabled(false);
        this.entityLink.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)disableReason)))});
    }

    private void syncWithInput() {
        ObjectAdapter adapter = ((ScalarModel)this.getModel()).getPendingElseCurrentAdapter();
        MarkupContainer componentForRegular = (MarkupContainer)this.getComponentForRegular();
        if (componentForRegular != null) {
            boolean inlinePrompt;
            EntityModelForReference entityModelForLink = new EntityModelForReference((ScalarModel)this.getModel());
            entityModelForLink.setContextAdapterIfAny(((ScalarModel)this.getModel()).getContextAdapterIfAny());
            entityModelForLink.setRenderingHint(((ScalarModel)this.getModel()).getRenderingHint());
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)entityModelForLink);
            Component component = componentFactory.createComponent(ComponentType.ENTITY_ICON_AND_TITLE.getWicketId(), (IModel<?>)entityModelForLink);
            componentForRegular.addOrReplace(new Component[]{component});
            boolean bl = inlinePrompt = this.scalarModel.getPromptStyle().isInline() && this.scalarModel.canEnterEditMode() || this.scalarModel.hasActionWithInlineAsIfEdit();
            if (inlinePrompt) {
                component.add(new Behavior[]{new CssClassAppender("inlinePrompt")});
            }
            if (adapter != null) {
                Components.permanentlyHide(componentForRegular, "entityTitleIfNull");
            } else if (inlinePrompt) {
                Components.permanentlyHide(componentForRegular, "entityTitleIfNull");
            } else {
                componentForRegular.addOrReplace(new Component[]{new Label("entityTitleIfNull", (Serializable)((Object)"(none)"))});
            }
        }
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            if (this.select2 == null) {
                throw new IllegalStateException("select2 should be created already");
            }
            this.select2.clearInput();
            if (this.getComponentForRegular() != null) {
                Components.permanentlyHide((MarkupContainer)this.getComponentForRegular(), ID_ENTITY_ICON_TITLE);
                Components.permanentlyHide(componentForRegular, "entityTitleIfNull");
            }
            if (this.select2 != null) {
                boolean mutability = this.entityLink.isEnableAllowed() && !((ScalarModel)this.getModel()).isViewMode();
                this.select2.setEnabled(mutability);
            }
            Components.permanentlyHide((MarkupContainer)this.entityLink, "entityLinkIfNull");
        } else {
            Components.permanentlyHide((MarkupContainer)this.entityLink, ID_AUTO_COMPLETE);
        }
    }

    @Override
    protected ChoiceProvider<ObjectAdapterMemento> buildChoiceProvider(ObjectAdapter[] argsIfAvailable) {
        if (((ScalarModel)this.getModel()).hasChoices()) {
            List<ObjectAdapterMemento> choiceMementos = this.obtainChoiceMementos(argsIfAvailable);
            return new ObjectAdapterMementoProviderForReferenceChoices((ScalarModel)this.getModel(), this.wicketViewerSettings, choiceMementos);
        }
        if (((ScalarModel)this.getModel()).hasAutoComplete()) {
            return new ObjectAdapterMementoProviderForReferenceParamOrPropertyAutoComplete((ScalarModel)this.getModel(), this.wicketViewerSettings);
        }
        return new ObjectAdapterMementoProviderForReferenceObjectAutoComplete((ScalarModel)this.getModel(), this.wicketViewerSettings);
    }

    private List<ObjectAdapterMemento> obtainChoiceMementos(ObjectAdapter[] argsIfAvailable) {
        ArrayList choices = Lists.newArrayList();
        if (((ScalarModel)this.getModel()).hasChoices()) {
            choices.addAll(((ScalarModel)this.getModel()).getChoices(argsIfAvailable, this.getAuthenticationSession(), this.getDeploymentCategory()));
        }
        return Lists.newArrayList((Iterable)Lists.transform((List)choices, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
    }

    @Override
    protected void syncIfNull(Select2 select2, List<ObjectAdapterMemento> choiceMementos) {
        ObjectAdapterMemento curr = select2.getModelObject();
        if (!((ScalarModel)this.getModel()).isCollection() && curr == null) {
            select2.getModel().setObject(null);
            ((ScalarModel)this.getModel()).setObject(null);
        }
    }

    private boolean autoSelect() {
        boolean disableAutoSelect = this.getConfiguration().getBoolean(KEY_DISABLE_DEPENDENT_CHOICE_AUTO_SELECTION, false);
        boolean autoSelect = !disableAutoSelect;
        return autoSelect;
    }

    String getInput() {
        ObjectAdapter pendingElseCurrentAdapter = ((ScalarModel)this.getModel()).getPendingElseCurrentAdapter();
        return pendingElseCurrentAdapter != null ? pendingElseCurrentAdapter.titleString(null) : "(no object)";
    }

    void convertInput() {
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            ObjectAdapterMemento convertedInput = this.select2.getConvertedInput();
            ((ScalarModel)this.getModel()).setPending(convertedInput);
            if (this.select2 != null) {
                this.select2.getModel().setObject((Object)convertedInput);
            }
            ObjectAdapter adapter = convertedInput != null ? convertedInput.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader()) : null;
            ((ScalarModel)this.getModel()).setObject(adapter);
        }
        ObjectAdapter pendingAdapter = ((ScalarModel)this.getModel()).getPendingAdapter();
        this.entityLink.setConvertedInput(pendingAdapter);
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract2 scalarPanel) {
        super.onUpdate(target, scalarPanel);
        target.appendJavaScript((CharSequence)String.format("Wicket.Event.publish(Isis.Topic.CLOSE_SELECT2, '%s')", this.getMarkupId()));
    }

    private boolean isEditableWithEitherAutoCompleteOrChoices() {
        if (((ScalarModel)this.getModel()).getRenderingHint().isInTable()) {
            return false;
        }
        if (((ScalarModel)this.getModel()).isViewMode()) {
            return false;
        }
        return ((ScalarModel)this.getModel()).hasChoices() || ((ScalarModel)this.getModel()).hasAutoComplete() || this.hasObjectAutoComplete();
    }

    private boolean hasObjectAutoComplete() {
        ObjectSpecification typeOfSpecification = ((ScalarModel)this.getModel()).getTypeOfSpecification();
        AutoCompleteFacet autoCompleteFacet = typeOfSpecification != null ? (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class) : null;
        return autoCompleteFacet != null;
    }

    @Override
    protected String getScalarPanelType() {
        return "referencePanel";
    }
}

