/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import java.io.Serializable;
import org.apache.isis.applib.value.Markup;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.StandaloneMarkupPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class MarkupPanelFactory
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;

    public MarkupPanelFactory(ComponentType componentType) {
        super(componentType, MarkupPanel.class);
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        switch (this.getComponentType()) {
            case SCALAR_NAME_AND_VALUE: {
                return this.appliesToIfScalar(model);
            }
            case VALUE: {
                return this.appliesToIfValue(model);
            }
        }
        return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    @Override
    public final Component createComponent(String id, IModel<?> model) {
        switch (this.getComponentType()) {
            case SCALAR_NAME_AND_VALUE: {
                return this.createComponentIfScalar(id, model);
            }
            case VALUE: {
                return this.createComponentIfValue(id, model);
            }
        }
        return new Label(id, (Serializable)((Object)("MarkupPanelFactory.createComponent: case not handled '" + (Object)((Object)this.getComponentType()) + "'")));
    }

    private ComponentFactory.ApplicationAdvice appliesToIfScalar(IModel<?> model) {
        if (!(model instanceof ScalarModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        ScalarModel scalarModel = (ScalarModel)model;
        if (!scalarModel.isScalarTypeAnyOf(new Class[]{Markup.class})) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        return this.appliesIf(!scalarModel.hasChoices());
    }

    private ComponentFactory.ApplicationAdvice appliesToIfValue(IModel<?> model) {
        if (!(model instanceof ValueModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        ValueModel valueModel = (ValueModel)model;
        ObjectAdapter adapter = (ObjectAdapter)valueModel.getObject();
        if (adapter == null || adapter.getObject() == null) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        return this.appliesIf(adapter.getObject() instanceof Markup);
    }

    private final Component createComponentIfScalar(String id, IModel<?> model) {
        return new MarkupPanel(id, (ScalarModel)model);
    }

    private final Component createComponentIfValue(String id, IModel<?> model) {
        return new StandaloneMarkupPanel(id, (ValueModel)model);
    }
}

