/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import org.apache.isis.applib.value.Markup;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;

public class MarkupComponent
extends WebComponent {
    private static final long serialVersionUID = 1L;

    public MarkupComponent(String id, IModel<?> model) {
        super(id, model);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        ObjectAdapter objAdapter = (ObjectAdapter)this.getDefaultModelObject();
        this.replaceComponentTagBody(markupStream, openTag, this.extractHtmlOrElse(objAdapter, ""));
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    private CharSequence extractHtmlOrElse(ObjectAdapter objAdapter, String fallback) {
        if (objAdapter == null || objAdapter.getObject() == null) {
            return fallback;
        }
        Object value = objAdapter.getObject();
        if (!(value instanceof Markup)) {
            return fallback;
        }
        return ((Markup)value).asString();
    }
}

