/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jodatime;

import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaAbstract;
import org.apache.wicket.util.convert.ConversionException;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;

public class DateConverterForJodaLocalDateTime
extends DateConverterForJodaAbstract<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJodaLocalDateTime(WicketViewerSettings settings, int adjustBy) {
        super(LocalDateTime.class, settings.getDatePattern(), settings.getDateTimePattern(), adjustBy);
    }

    @Override
    protected LocalDateTime minusDays(LocalDateTime value, int adjustBy) {
        return value.minusDays(adjustBy);
    }

    @Override
    protected LocalDateTime plusDays(LocalDateTime value, int adjustBy) {
        return value.plusDays(adjustBy);
    }

    @Override
    protected LocalDateTime convert(String value) throws ConversionException {
        try {
            return this.getFormatterForDateTimePattern().parseLocalDateTime(value);
        }
        catch (IllegalArgumentException ex) {
            try {
                return this.getFormatterForDatePattern().parseLocalDateTime(value);
            }
            catch (IllegalArgumentException ex2) {
                throw new ConversionException(String.format("Cannot convert '%s' into a date/time", value), (Throwable)ex2);
            }
        }
    }

    @Override
    protected String toString(LocalDateTime value, DateTimeFormatter dateTimeFormatter) {
        return value.toString(dateTimeFormatter);
    }
}

