/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jodatime;

import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaAbstract;
import org.apache.wicket.util.convert.ConversionException;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;

public class DateConverterForJodaLocalDate
extends DateConverterForJodaAbstract<LocalDate> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJodaLocalDate(WicketViewerSettings settings, int adjustBy) {
        super(LocalDate.class, settings.getDatePattern(), settings.getDatePattern(), adjustBy);
    }

    @Override
    protected LocalDate minusDays(LocalDate value, int adjustBy) {
        return value.minusDays(adjustBy);
    }

    @Override
    protected LocalDate plusDays(LocalDate value, int adjustBy) {
        return value.plusDays(adjustBy);
    }

    @Override
    protected LocalDate convert(String value) throws ConversionException {
        try {
            return this.getFormatterForDateTimePattern().parseLocalDate(value);
        }
        catch (IllegalArgumentException ex) {
            throw new ConversionException(String.format("Cannot convert '%s' into a date/time", value), (Throwable)ex);
        }
    }

    @Override
    protected String toString(LocalDate value, DateTimeFormatter dateTimeFormatter) {
        return value.toString(dateTimeFormatter);
    }
}

