/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.datepicker;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Locale;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker.DateTimeConfig;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;

public class TextFieldWithDateTimePicker<T>
extends TextField<T>
implements IConverter<T> {
    private static final long serialVersionUID = 1L;
    private static final String KEY_DATE_PICKER_MIN_DATE = "isis.viewer.wicket.datePicker.minDate";
    private static final String KEY_DATE_PICKER_MIN_DATE_DEFAULT = "1900-01-01T00:00:00.000Z";
    private static final String KEY_DATE_PICKER_MAX_DATE = "isis.viewer.wicket.datePicker.maxDate";
    private static final String KEY_DATE_PICKER_MAX_DATE_DEFAULT = "2100-01-01T00:00:00.000Z";
    protected final DateConverter<T> converter;
    private final DateTimeConfig config;

    public TextFieldWithDateTimePicker(String id, IModel<T> model, Class<T> type, DateConverter<T> converter) {
        super(id, model, type);
        DateTimeConfig config = new DateTimeConfig();
        this.setOutputMarkupId(true);
        this.converter = converter;
        String dateTimePattern = converter.getDateTimePattern(this.getLocale());
        String pattern = this.convertToMomentJsFormat(dateTimePattern);
        config.withFormat(pattern);
        boolean patternContainsTimeComponent = pattern.contains("HH");
        if (patternContainsTimeComponent) {
            config.sideBySide(true);
        }
        config.calendarWeeks(true);
        config.useCurrent(false);
        String datePickerMinDate = this.getConfiguration().getString(KEY_DATE_PICKER_MIN_DATE, KEY_DATE_PICKER_MIN_DATE_DEFAULT);
        String datePickerMaxDate = this.getConfiguration().getString(KEY_DATE_PICKER_MAX_DATE, KEY_DATE_PICKER_MAX_DATE_DEFAULT);
        config.minDate(datePickerMinDate);
        config.maxDate(datePickerMaxDate);
        this.config = config;
    }

    private String convertToMomentJsFormat(String javaDateTimeFormat) {
        String momentJsFormat = javaDateTimeFormat;
        momentJsFormat = momentJsFormat.replace('d', 'D');
        momentJsFormat = momentJsFormat.replace('y', 'Y');
        return momentJsFormat;
    }

    public T convertToObject(String value, Locale locale) {
        return (T)this.converter.convertToObject(value, locale);
    }

    public String convertToString(T value, Locale locale) {
        return this.converter.convertToString(value, locale);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (this.converter.getConvertableClass().isAssignableFrom(type)) {
            return this;
        }
        return super.getConverter(type);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(TextFieldWithDateTimePicker.class, "css/bootstrap-datetimepicker.css")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(TextFieldWithDateTimePicker.class, "js/moment.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(TextFieldWithDateTimePicker.class, "js/bootstrap-datetimepicker.js")));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.config)));
    }

    private CharSequence createScript(DateTimeConfig config) {
        return JQuery.$((Component)this).chain((CharSequence)"datetimepicker", (Config)config, new Config[0]).get();
    }

    IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

