/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import org.apache.isis.applib.services.i18n.LocaleProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;

public abstract class ScalarPanelTextFieldNumeric<T extends Serializable>
extends ScalarPanelTextFieldAbstract<T> {
    private static final long serialVersionUID = 1L;
    private final IConverter<T> converter;

    public ScalarPanelTextFieldNumeric(String id, ScalarModel scalarModel, Class<T> cls, IConverter<T> converter) {
        super(id, scalarModel, cls);
        this.converter = converter;
    }

    @Override
    protected Component createComponentForCompact() {
        Fragment compactFragment = this.getCompactFragment(ScalarPanelTextFieldAbstract.CompactType.SPAN);
        Label label = new Label("scalarIfCompact", (IModel)this.newTextFieldValueModel()){

            public <C> IConverter<C> getConverter(Class<C> type) {
                return ScalarPanelTextFieldNumeric.this.converter;
            }
        };
        label.setEnabled(false);
        compactFragment.add(new Component[]{label});
        return label;
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        return new Model<String>(){

            public String getObject() {
                ObjectAdapter object = (ObjectAdapter)ScalarPanelTextFieldNumeric.this.scalarModel.getObject();
                Serializable value = object != null ? (Serializable)object.getObject() : null;
                String str = value != null ? ScalarPanelTextFieldNumeric.this.converter.convertToString((Object)value, ScalarPanelTextFieldNumeric.this.getLocaleProvider().getLocale()) : null;
                return str;
            }
        };
    }

    private LocaleProvider getLocaleProvider() {
        return (LocaleProvider)IsisContext.getSessionFactory().getServicesInjector().lookupService(LocaleProvider.class);
    }
}

