/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.isis.applib.services.i18n.LocaleProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker.TextFieldWithDateTimePicker;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;

public abstract class ScalarPanelTextFieldDatePickerAbstract<T extends Serializable>
extends ScalarPanelTextFieldAbstract<T> {
    private static final long serialVersionUID = 1L;
    protected DateConverter<T> converter;
    @Inject
    WicketViewerSettings settings;

    public ScalarPanelTextFieldDatePickerAbstract(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel, cls);
    }

    protected void init(DateConverter<T> converter) {
        this.converter = converter;
    }

    protected int getAdjustBy() {
        RenderedAdjustedFacet facet = (RenderedAdjustedFacet)((ScalarModel)this.getModel()).getFacet(RenderedAdjustedFacet.class);
        return facet != null ? facet.value() : 0;
    }

    @Override
    protected TextField<T> createTextField(String id) {
        return new TextFieldWithDateTimePicker(id, this.newTextFieldValueModel(), this.cls, this.converter);
    }

    @Override
    protected String createTextFieldFragmentId() {
        return "date";
    }

    @Override
    protected Component createComponentForCompact() {
        Fragment compactFragment = this.getCompactFragment(ScalarPanelTextFieldAbstract.CompactType.SPAN);
        Label label = new Label("scalarIfCompact", (IModel)this.newTextFieldValueModel()){

            public <C> IConverter<C> getConverter(Class<C> type) {
                return ScalarPanelTextFieldDatePickerAbstract.this.converter;
            }
        };
        label.setEnabled(false);
        int lengthAdjust = this.getLengthAdjustHint() != null ? this.getLengthAdjustHint() : 1;
        String dateTimePattern = this.converter.getDateTimePattern(this.getLocale());
        int length = dateTimePattern.length() + lengthAdjust;
        label.add(new Behavior[]{new AttributeModifier("size", (IModel)Model.of((Serializable)((Object)("" + length))))});
        compactFragment.add(new Component[]{label});
        return label;
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        return new Model<String>(){

            public String getObject() {
                ObjectAdapter object = (ObjectAdapter)ScalarPanelTextFieldDatePickerAbstract.this.scalarModel.getObject();
                Serializable value = object != null ? (Serializable)object.getObject() : null;
                String str = value != null ? ScalarPanelTextFieldDatePickerAbstract.this.converter.convertToString(value, ScalarPanelTextFieldDatePickerAbstract.this.getLocaleProvider().getLocale()) : null;
                return str;
            }
        };
    }

    protected Integer getLengthAdjustHint() {
        return null;
    }

    @Override
    protected WicketViewerSettings getSettings() {
        return this.settings;
    }

    private LocaleProvider getLocaleProvider() {
        return (LocaleProvider)IsisContext.getSessionFactory().getServicesInjector().lookupService(LocaleProvider.class);
    }
}

