/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.InlinePromptContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelUtil;
import org.apache.isis.viewer.wicket.ui.components.property.PropertyEditFormPanel;
import org.apache.isis.viewer.wicket.ui.components.property.PropertyEditPanel;
import org.apache.isis.viewer.wicket.ui.components.propertyheader.PropertyEditPromptHeaderPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelSubscriber2;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;

public abstract class ScalarPanelAbstract2
extends PanelAbstract<ScalarModel>
implements ScalarModelSubscriber2 {
    private static final long serialVersionUID = 1L;
    protected static final String ID_SCALAR_TYPE_CONTAINER = "scalarTypeContainer";
    protected static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    protected static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    protected static final String ID_SCALAR_NAME = "scalarName";
    protected static final String ID_SCALAR_VALUE = "scalarValue";
    protected static final String ID_SCALAR_VALUE_INLINE_PROMPT_LINK = "scalarValueInlinePromptLink";
    protected static final String ID_SCALAR_VALUE_INLINE_PROMPT_LABEL = "scalarValueInlinePromptLabel";
    public static final String ID_SCALAR_IF_REGULAR_INLINE_PROMPT_FORM = "scalarIfRegularInlinePromptForm";
    private static final String ID_EDIT_PROPERTY = "editProperty";
    private static final String ID_FEEDBACK = "feedback";
    private static final String ID_ASSOCIATED_ACTION_LINKS_BELOW = "associatedActionLinksBelow";
    private static final String ID_ASSOCIATED_ACTION_LINKS_RIGHT = "associatedActionLinksRight";
    protected final ScalarModel scalarModel;
    private Component scalarIfCompact;
    private MarkupContainer scalarIfRegular;
    private WebMarkupContainer scalarTypeContainer;
    private WebMarkupContainer scalarIfRegularInlinePromptForm;
    WebMarkupContainer inlinePromptLink;
    private final List<ScalarModelSubscriber2> subscribers = Lists.newArrayList();

    public ScalarPanelAbstract2(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.scalarModel = scalarModel;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGuiAndCallHooks();
        this.setOutputMarkupId(true);
    }

    private void buildGuiAndCallHooks() {
        try {
            this.buildGui();
        }
        catch (ConcurrencyException ex) {
            IsisContext.getSessionFactory().getCurrentSession().getAuthenticationSession().getMessageBroker().addMessage(ex.getMessage());
            ObjectAdapter parentAdapter = ((ScalarModel)this.getModel()).getParentEntityModel().load();
            throw new RestartResponseException((IRequestablePage)new EntityPage(parentAdapter));
        }
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        if (scalarModel.isViewMode()) {
            this.onInitializeWhenViewMode();
        } else {
            String disableReasonIfAny = scalarModel.whetherDisabled();
            if (disableReasonIfAny != null) {
                this.onInitializeWhenDisabled(disableReasonIfAny);
            } else {
                this.onInitializeWhenEnabled();
            }
        }
    }

    protected abstract String getScalarPanelType();

    protected abstract InlinePromptConfig getInlinePromptConfig();

    private void buildGui() {
        this.scalarTypeContainer = new WebMarkupContainer(ID_SCALAR_TYPE_CONTAINER);
        this.scalarTypeContainer.setOutputMarkupId(true);
        this.scalarTypeContainer.add(new Behavior[]{new CssClassAppender((IModel<String>)Model.of((Serializable)((Object)this.getScalarPanelType())))});
        this.addOrReplace(new Component[]{this.scalarTypeContainer});
        this.scalarIfCompact = this.createComponentForCompact();
        this.scalarIfRegular = this.createComponentForRegular();
        this.scalarIfRegular.setOutputMarkupId(true);
        this.scalarTypeContainer.addOrReplace(new Component[]{this.scalarIfCompact, this.scalarIfRegular});
        ArrayList linkAndLabels = LinkAndLabelUtil.asActionLinksForAssociation(this.scalarModel, this.getDeploymentCategory());
        InlinePromptConfig inlinePromptConfig = this.getInlinePromptConfig();
        if (inlinePromptConfig.isSupported()) {
            this.scalarIfRegularInlinePromptForm = this.createInlinePromptForm();
            this.scalarTypeContainer.addOrReplace(new Component[]{this.scalarIfRegularInlinePromptForm});
            this.inlinePromptLink = this.createInlinePromptLink();
            this.scalarIfRegular.add(new Component[]{this.inlinePromptLink});
            this.scalarModel.setInlinePromptContext(new InlinePromptContext(this.getComponentForRegular(), this.scalarIfRegularInlinePromptForm, (MarkupContainer)this.scalarTypeContainer));
            WebMarkupContainer componentToHideIfAny = this.inlinePromptLink;
            LinkAndLabel linkAndLabelAsIfEdit = ScalarPanelAbstract2.inlineAsIfEditIfAny(linkAndLabels);
            if (this.scalarModel.getPromptStyle().isInline() && this.scalarModel.canEnterEditMode()) {
                this.configureInlinePromptLinkCallback(this.inlinePromptLink);
                componentToHideIfAny = inlinePromptConfig.getComponentToHideIfAny();
            } else if (linkAndLabelAsIfEdit != null) {
                this.scalarModel.setHasActionWithInlineAsIfEdit(true);
                ActionLink actionLinkInlineAsIfEdit = (ActionLink)linkAndLabelAsIfEdit.getLink();
                if (actionLinkInlineAsIfEdit.isVisible() && actionLinkInlineAsIfEdit.isEnabled()) {
                    this.configureInlinePromptLinkCallback(this.inlinePromptLink, actionLinkInlineAsIfEdit);
                    componentToHideIfAny = inlinePromptConfig.getComponentToHideIfAny();
                }
            }
            if (linkAndLabelAsIfEdit != null) {
                linkAndLabels = Lists.newArrayList(linkAndLabels);
                linkAndLabels.remove(linkAndLabelAsIfEdit);
            }
            if (componentToHideIfAny != null) {
                componentToHideIfAny.setVisibilityAllowed(false);
            }
        }
        if (this.scalarModel.getKind() == ScalarModel.Kind.PROPERTY && this.scalarModel.getMode() == EntityModel.Mode.VIEW && (this.scalarModel.getPromptStyle().isDialog() || !this.scalarModel.canEnterEditMode())) {
            this.getScalarValueComponent().add(new Behavior[]{new AttributeAppender("tabindex", (Serializable)((Object)"-1"))});
        }
        this.addPositioningCssTo(this.scalarIfRegular, linkAndLabels);
        this.addActionLinksBelowAndRight(this.scalarIfRegular, linkAndLabels);
        this.addEditPropertyTo(this.scalarIfRegular);
        this.addFeedbackOnlyTo(this.scalarIfRegular, this.getScalarValueComponent());
        this.getRendering().buildGui(this);
        this.addCssFromMetaModel();
        this.notifyOnChange(this);
        this.addFormComponentBehaviourToUpdateSubscribers();
    }

    private static LinkAndLabel inlineAsIfEditIfAny(List<LinkAndLabel> linkAndLabels) {
        for (LinkAndLabel linkAndLabel : linkAndLabels) {
            PromptStyle promptStyle;
            AbstractLink link = linkAndLabel.getLink();
            if (!(link instanceof ActionLink) || !(promptStyle = linkAndLabel.getPromptStyle()).isInlineAsIfEdit()) continue;
            return linkAndLabel;
        }
        return null;
    }

    protected void onInitializeWhenViewMode() {
    }

    protected void onInitializeWhenDisabled(String disableReason) {
    }

    protected void onInitializeWhenEnabled() {
    }

    private void addCssFromMetaModel() {
        ScalarModel model;
        CssClassFacet facet;
        String cssForMetaModel = ((ScalarModel)this.getModel()).getCssClass();
        if (!Strings.isNullOrEmpty((String)cssForMetaModel)) {
            CssClassAppender.appendCssClassTo((MarkupContainer)this, CssClassAppender.asCssStyle(cssForMetaModel));
        }
        if ((facet = (CssClassFacet)(model = (ScalarModel)this.getModel()).getFacet(CssClassFacet.class)) != null) {
            ObjectAdapter parentAdapter = model.getParentEntityModel().load(AdapterManager.ConcurrencyChecking.NO_CHECK);
            String cssClass = facet.cssClass(parentAdapter);
            CssClassAppender.appendCssClassTo((MarkupContainer)this, cssClass);
        }
    }

    protected void onConfigure() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        boolean hidden = scalarModel.whetherHidden();
        this.setVisibilityAllowed(!hidden);
        super.onConfigure();
    }

    public void notifyOnChange(ScalarModelSubscriber2 subscriber) {
        this.subscribers.add(subscriber);
    }

    private void addFormComponentBehaviourToUpdateSubscribers() {
        Component scalarValueComponent = this.getScalarValueComponent();
        if (scalarValueComponent == null) {
            return;
        }
        for (Behavior b : scalarValueComponent.getBehaviors(ScalarUpdatingBehavior.class)) {
            scalarValueComponent.remove(new Behavior[]{b});
        }
        scalarValueComponent.add(new Behavior[]{new ScalarUpdatingBehavior(this)});
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract2 scalarPanel) {
        if (((ScalarModel)this.getModel()).getKind() == ScalarModel.Kind.PARAMETER) {
            target.appendJavaScript((CharSequence)String.format("Wicket.Event.publish(Isis.Topic.FOCUS_FIRST_PARAMETER, '%s')", this.getMarkupId()));
        }
    }

    @Override
    public void onError(AjaxRequestTarget target, ScalarPanelAbstract2 scalarPanel) {
    }

    protected Rendering getRendering() {
        return Rendering.renderingFor(this.scalarModel.getRenderingHint());
    }

    protected Component getComponentForRegular() {
        return this.scalarIfRegular;
    }

    protected abstract MarkupContainer createComponentForRegular();

    protected abstract Component createComponentForCompact();

    protected Label createScalarName(String id, String labelCaption) {
        NamedFacet namedFacet;
        String label;
        Label scalarName = new Label(id, (Serializable)((Object)labelCaption));
        ScalarModel model = (ScalarModel)this.getModel();
        if (model.isRequired() && model.isEnabled() && !Strings.isNullOrEmpty((String)(label = scalarName.getDefaultModelObjectAsString()))) {
            scalarName.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        if ((namedFacet = (NamedFacet)model.getFacet(NamedFacet.class)) != null) {
            scalarName.setEscapeModelStrings(namedFacet.escaped());
        }
        return scalarName;
    }

    private WebMarkupContainer createInlinePromptForm() {
        WebMarkupContainer scalarIfRegularInlinePromptForm = new WebMarkupContainer(ID_SCALAR_IF_REGULAR_INLINE_PROMPT_FORM);
        scalarIfRegularInlinePromptForm.setOutputMarkupId(true);
        scalarIfRegularInlinePromptForm.setVisible(false);
        return scalarIfRegularInlinePromptForm;
    }

    private WebMarkupContainer createInlinePromptLink() {
        IModel<String> inlinePromptModel = this.obtainInlinePromptModel();
        if (inlinePromptModel == null) {
            throw new IllegalStateException(this.getClass().getName() + ": obtainInlinePromptModel() returning null is not compatible with supportsInlinePrompt() returning true ");
        }
        WebMarkupContainer inlinePromptLink = new WebMarkupContainer(ID_SCALAR_VALUE_INLINE_PROMPT_LINK);
        inlinePromptLink.setOutputMarkupId(true);
        this.configureInlinePromptLink(inlinePromptLink);
        Component editInlineLinkLabel = this.createInlinePromptComponent(ID_SCALAR_VALUE_INLINE_PROMPT_LABEL, inlinePromptModel);
        inlinePromptLink.add(new Component[]{editInlineLinkLabel});
        return inlinePromptLink;
    }

    protected void configureInlinePromptLink(WebMarkupContainer inlinePromptLink) {
        String append = this.obtainInlinePromptLinkCssIfAny();
        if (append != null) {
            inlinePromptLink.add(new Behavior[]{new CssClassAppender(append)});
        }
    }

    protected String obtainInlinePromptLinkCssIfAny() {
        return "form-control input-sm";
    }

    protected Component createInlinePromptComponent(String id, IModel<String> inlinePromptModel) {
        return new Label(id, inlinePromptModel){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
    }

    protected IModel<String> obtainInlinePromptModel() {
        return null;
    }

    private void configureInlinePromptLinkCallback(WebMarkupContainer inlinePromptLink) {
        inlinePromptLink.add(new Behavior[]{new AjaxEventBehavior("click"){

            protected void onEvent(AjaxRequestTarget target) {
                ScalarPanelAbstract2.this.scalarModel.toEditMode();
                ScalarPanelAbstract2.this.switchFormForInlinePrompt(target);
                ScalarPanelAbstract2.this.getComponentForRegular().setVisible(false);
                ScalarPanelAbstract2.this.scalarIfRegularInlinePromptForm.setVisible(true);
                target.add(new Component[]{ScalarPanelAbstract2.this.scalarTypeContainer});
            }

            public boolean isEnabled(Component component) {
                return true;
            }
        }});
    }

    private void configureInlinePromptLinkCallback(WebMarkupContainer inlinePromptLink, final ActionLink actionLink) {
        inlinePromptLink.add(new Behavior[]{new AjaxEventBehavior("click"){

            protected void onEvent(AjaxRequestTarget target) {
                actionLink.onClick(target);
            }

            public boolean isEnabled(Component component) {
                return true;
            }
        }});
    }

    private void switchFormForInlinePrompt(AjaxRequestTarget target) {
        this.scalarIfRegularInlinePromptForm = (PropertyEditFormPanel)this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this.scalarTypeContainer, ID_SCALAR_IF_REGULAR_INLINE_PROMPT_FORM, ComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.scalarModel);
        this.onSwitchFormForInlinePrompt(this.scalarIfRegularInlinePromptForm, target);
    }

    protected void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
    }

    protected void addEditPropertyTo(MarkupContainer scalarIfRegularFormGroup) {
        if (this.scalarModel.canEnterEditMode() && (this.scalarModel.getPromptStyle().isDialog() || !this.getInlinePromptConfig().isSupported())) {
            WebMarkupContainer editProperty = new WebMarkupContainer(ID_EDIT_PROPERTY);
            editProperty.setOutputMarkupId(true);
            scalarIfRegularFormGroup.addOrReplace(new Component[]{editProperty});
            editProperty.add(new Behavior[]{new AjaxEventBehavior("click"){

                protected void onEvent(AjaxRequestTarget target) {
                    ActionPrompt prompt = ActionPromptProvider.Util.getFrom((Component)ScalarPanelAbstract2.this).getActionPrompt();
                    PropertyEditPromptHeaderPanel titlePanel = new PropertyEditPromptHeaderPanel(prompt.getTitleId(), ScalarPanelAbstract2.this.scalarModel);
                    PropertyEditPanel propertyEditPanel = (PropertyEditPanel)ScalarPanelAbstract2.this.getComponentFactoryRegistry().createComponent(ComponentType.PROPERTY_EDIT_PROMPT, prompt.getContentId(), (IModel<?>)ScalarPanelAbstract2.this.scalarModel);
                    propertyEditPanel.setShowHeader(false);
                    prompt.setTitle((Component)titlePanel, target);
                    prompt.setPanel((Component)propertyEditPanel, target);
                    prompt.showPrompt(target);
                }
            }});
        } else {
            Components.permanentlyHide(scalarIfRegularFormGroup, ID_EDIT_PROPERTY);
        }
    }

    protected abstract Component getScalarValueComponent();

    private void addFeedbackOnlyTo(MarkupContainer markupContainer, Component component) {
        markupContainer.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, component, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(component))});
    }

    private void addActionLinksBelowAndRight(MarkupContainer labelIfRegular, List<LinkAndLabel> linkAndLabels) {
        List linksBelow = LinkAndLabel.positioned(linkAndLabels, (ActionLayout.Position)ActionLayout.Position.BELOW);
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ID_ASSOCIATED_ACTION_LINKS_BELOW, linksBelow, AdditionalLinksPanel.Style.INLINE_LIST);
        List linksRight = LinkAndLabel.positioned(linkAndLabels, (ActionLayout.Position)ActionLayout.Position.RIGHT);
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ID_ASSOCIATED_ACTION_LINKS_RIGHT, linksRight, AdditionalLinksPanel.Style.DROPDOWN);
    }

    private void addPositioningCssTo(MarkupContainer markupContainer, List<LinkAndLabel> actionLinks) {
        CssClassAppender.appendCssClassTo(markupContainer, ScalarPanelAbstract2.determinePropParamLayoutCss((ScalarModel)this.getModel()));
        CssClassAppender.appendCssClassTo(markupContainer, ScalarPanelAbstract2.determineActionLayoutPositioningCss(actionLinks));
    }

    private static String determinePropParamLayoutCss(ScalarModel model) {
        LabelAtFacet facet = (LabelAtFacet)model.getFacet(LabelAtFacet.class);
        if (facet != null) {
            switch (facet.label()) {
                case LEFT: {
                    return "label-left";
                }
                case RIGHT: {
                    return "label-right";
                }
                case NONE: {
                    return "label-none";
                }
                case TOP: {
                    return "label-top";
                }
            }
        }
        return "label-left";
    }

    private static String determineActionLayoutPositioningCss(List<LinkAndLabel> entityActionLinks) {
        boolean actionsPositionedOnRight = ScalarPanelAbstract2.hasActionsPositionedOn(entityActionLinks, ActionLayout.Position.RIGHT);
        return actionsPositionedOnRight ? "actions-right" : null;
    }

    private static boolean hasActionsPositionedOn(List<LinkAndLabel> entityActionLinks, ActionLayout.Position position) {
        for (LinkAndLabel entityActionLink : entityActionLinks) {
            if (entityActionLink.getPosition() != position) continue;
            return true;
        }
        return false;
    }

    public void repaint(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    public static enum Rendering {
        COMPACT{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return "";
            }

            @Override
            public void buildGui(ScalarPanelAbstract2 panel) {
                panel.getComponentForRegular().setVisible(false);
            }
        }
        ,
        REGULAR{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return (String)labeledContainer.getLabel().getObject();
            }

            @Override
            public void buildGui(ScalarPanelAbstract2 panel) {
                panel.scalarIfCompact.setVisible(false);
            }
        };


        public abstract String getLabelCaption(LabeledWebMarkupContainer var1);

        public abstract void buildGui(ScalarPanelAbstract2 var1);

        private static Rendering renderingFor(EntityModel.RenderingHint renderingHint) {
            return renderingHint.isRegular() ? REGULAR : COMPACT;
        }
    }

    static class ScalarUpdatingBehavior
    extends AjaxFormComponentUpdatingBehavior {
        private static final long serialVersionUID = 1L;
        private final ScalarPanelAbstract2 scalarPanel;

        private ScalarUpdatingBehavior(ScalarPanelAbstract2 scalarPanel) {
            super("change");
            this.scalarPanel = scalarPanel;
        }

        protected void onUpdate(AjaxRequestTarget target) {
            for (ScalarModelSubscriber2 subscriber : this.scalarPanel.subscribers) {
                subscriber.onUpdate(target, this.scalarPanel);
            }
        }

        protected void onError(AjaxRequestTarget target, RuntimeException e) {
            super.onError(target, e);
            for (ScalarModelSubscriber2 subscriber : this.scalarPanel.subscribers) {
                subscriber.onError(target, this.scalarPanel);
            }
        }
    }

    public static class InlinePromptConfig {
        private final boolean supported;
        private final Component componentToHideIfAny;

        public static InlinePromptConfig supported() {
            return new InlinePromptConfig(true, null);
        }

        public static InlinePromptConfig notSupported() {
            return new InlinePromptConfig(false, null);
        }

        public static InlinePromptConfig supportedAndHide(Component componentToHideIfAny) {
            return new InlinePromptConfig(true, componentToHideIfAny);
        }

        private InlinePromptConfig(boolean supported, Component componentToHideIfAny) {
            this.supported = supported;
            this.componentToHideIfAny = componentToHideIfAny;
        }

        boolean isSupported() {
            return this.supported;
        }

        Component getComponentToHideIfAny() {
            return this.componentToHideIfAny;
        }
    }
}

