/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.propertyheader;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class PropertyEditPromptHeaderPanel
extends PanelAbstract<ScalarModel> {
    private static final String ID_PROPERTY_NAME = "propertyName";

    public PropertyEditPromptHeaderPanel(String id, final ScalarModel model) {
        super(id, model);
        ObjectAdapter targetAdapter = model.getParentEntityModel().load(AdapterManager.ConcurrencyChecking.NO_CHECK);
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)new EntityModel(targetAdapter));
        Label label = new Label(ID_PROPERTY_NAME, (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                OneToOneAssociation property = model.getPropertyMemento().getProperty(PropertyEditPromptHeaderPanel.this.getSpecificationLoader());
                return property.getName();
            }
        });
        OneToOneAssociation property = model.getPropertyMemento().getProperty(this.getSpecificationLoader());
        NamedFacet namedFacet = (NamedFacet)property.getFacet(NamedFacet.class);
        if (namedFacet != null) {
            label.setEscapeModelStrings(namedFacet.escaped());
        }
        this.add(new Component[]{label});
    }
}

