/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.property;

import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.viewer.wicket.model.hints.IsisPropertyEditCompletedEvent;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.property.PropertyFormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.panels.PromptFormAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;

class PropertyEditForm
extends PromptFormAbstract<ScalarModel> {
    private static final long serialVersionUID = 1L;

    public PropertyEditForm(String id, Component parentPanel, WicketViewerSettings settings, ScalarModel propertyModel) {
        super(id, parentPanel, settings, propertyModel);
    }

    private ScalarModel getScalarModel() {
        return (ScalarModel)super.getModel();
    }

    @Override
    protected void addParameters() {
        ScalarModel scalarModel = this.getScalarModel();
        WebMarkupContainer container = new WebMarkupContainer("property");
        this.add(new Component[]{container});
        this.newParamPanel(container, (IModel<?>)scalarModel);
    }

    private ScalarPanelAbstract2 newParamPanel(WebMarkupContainer container, IModel<?> model) {
        ScalarPanelAbstract2 paramPanel;
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, ComponentType.SCALAR_NAME_AND_VALUE, model);
        ScalarPanelAbstract2 scalarPanelAbstract2 = paramPanel = component instanceof ScalarPanelAbstract2 ? (ScalarPanelAbstract2)component : null;
        if (paramPanel != null) {
            paramPanel.setOutputMarkupId(true);
            paramPanel.notifyOnChange(this);
        }
        return paramPanel;
    }

    @Override
    protected Object newCompletedEvent(AjaxRequestTarget target, Form<?> form) {
        return new IsisPropertyEditCompletedEvent(this.getScalarModel(), target, form);
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract2 scalarPanel) {
    }

    @Override
    public void onCancelSubmitted(AjaxRequestTarget target) {
        PromptStyle promptStyle = this.getScalarModel().getPromptStyle();
        if (promptStyle.isInlineOrInlineAsIfEdit()) {
            this.getScalarModel().toViewMode();
            this.getScalarModel().clearPending();
        }
        super.onCancelSubmitted(target);
    }

    @Override
    protected FormExecutorStrategy<ScalarModel> getFormExecutorStrategy() {
        ScalarModel scalarModel = this.getScalarModel();
        return new PropertyFormExecutorStrategy(scalarModel);
    }
}

