/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs3.tabs;

import org.apache.isis.applib.layout.grid.bootstrap3.BS3Element;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.viewer.wicket.model.hints.HasUiHintDisambiguator;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.Util;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.row.Row;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class TabPanel
extends PanelAbstract
implements HasUiHintDisambiguator,
HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_TAB_PANEL = "tabPanel";
    private static final String ID_ROWS = "rows";
    private final BS3Tab bs3Tab;
    private boolean visible = false;

    public TabPanel(String id, EntityModel model, BS3Tab bs3Tab) {
        this(id, model, bs3Tab, null);
    }

    public TabPanel(String id, EntityModel model, BS3Tab bs3Tab, RepeatingViewWithDynamicallyVisibleContent repeatingViewWithDynamicallyVisibleContent) {
        super(id);
        this.bs3Tab = bs3Tab;
        this.buildGui(model, bs3Tab, repeatingViewWithDynamicallyVisibleContent);
    }

    public String getHintDisambiguator() {
        return this.bs3Tab.getName();
    }

    protected void buildGui(EntityModel model, BS3Tab bs3Tab, RepeatingViewWithDynamicallyVisibleContent rvIfAny) {
        WebMarkupContainer div = new WebMarkupContainer(ID_TAB_PANEL);
        RepeatingViewWithDynamicallyVisibleContent rv = rvIfAny != null ? rvIfAny : TabPanel.newRows(model, bs3Tab);
        div.add(new Component[]{rv});
        this.visible = this.visible || rv.isVisible();
        TabPanel panel = this;
        if (this.visible) {
            Util.appendCssClassIfRequired((MarkupContainer)panel, (BS3Element)bs3Tab);
            panel.add(new Component[]{div});
        } else {
            Components.permanentlyHide((MarkupContainer)panel, div.getId());
        }
    }

    public static RepeatingViewWithDynamicallyVisibleContent newRows(EntityModel model, BS3Tab bs3Tab) {
        RepeatingViewWithDynamicallyVisibleContent rv = new RepeatingViewWithDynamicallyVisibleContent(ID_ROWS);
        for (BS3Row bs3Row : bs3Tab.getRows()) {
            String newChildId = rv.newChildId();
            Row row = new Row(newChildId, model, bs3Row);
            rv.add(new Component[]{row});
        }
        return rv;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

