/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.icontitle;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class EntityIconAndTitlePanel
extends PanelAbstract<ObjectAdapterModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_LINK_WRAPPER = "entityLinkWrapper";
    private static final String ID_ENTITY_FONT_AWESOME = "entityFontAwesome";
    private static final String ID_ENTITY_LINK = "entityLink";
    private static final String ID_ENTITY_TITLE = "entityTitle";
    private static final String ID_ENTITY_ICON = "entityImage";
    private Label label;
    private Image image;
    @Inject
    private transient IsisSessionFactory isisSessionFactory;
    @Inject
    private ImageResourceCache imageCache;
    @Inject
    private WicketViewerSettings settings;

    public EntityIconAndTitlePanel(String id, ObjectAdapterModel objectAdapterModel) {
        super(id, objectAdapterModel);
    }

    public ObjectAdapterModel getEntityModel() {
        return (ObjectAdapterModel)this.getModel();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceLinkWrapper();
        if (this.isTitleSuppressed()) {
            this.add(new Behavior[]{new CssClassAppender("inlinePrompt")});
        }
        this.setOutputMarkupId(true);
    }

    private boolean isTitleSuppressed() {
        return ((ObjectAdapterModel)this.getModel()).isInlinePrompt() && !((ObjectAdapterModel)this.getModel()).getRenderingHint().isInTable();
    }

    private void addOrReplaceLinkWrapper() {
        ObjectAdapterModel entityModel = (ObjectAdapterModel)this.getModel();
        WebMarkupContainer entityLinkWrapper = this.addOrReplaceLinkWrapper(entityModel);
        this.addOrReplace(new Component[]{entityLinkWrapper});
    }

    protected WebMarkupContainer addOrReplaceLinkWrapper(ObjectAdapterModel entityModel) {
        ObjectAdapter adapter = (ObjectAdapter)entityModel.getObject();
        WebMarkupContainer entityLinkWrapper = new WebMarkupContainer(ID_ENTITY_LINK_WRAPPER);
        entityLinkWrapper.addOrReplace(new Component[]{this.createLinkWithIconAndTitle(adapter)});
        return entityLinkWrapper;
    }

    private AbstractLink createLinkWithIconAndTitle(ObjectAdapter adapterIfAny) {
        AbstractLink link = this.createDynamicallyVisibleLink();
        if (adapterIfAny != null) {
            String iconName = adapterIfAny.getIconName();
            CssClassFaFacet cssClassFaFacet = (CssClassFaFacet)adapterIfAny.getSpecification().getFacet(CssClassFaFacet.class);
            if (iconName != null || cssClassFaFacet == null) {
                Component[] componentArray = new Component[1];
                this.image = this.newImage(ID_ENTITY_ICON, adapterIfAny);
                componentArray[0] = this.image;
                link.addOrReplace(componentArray);
                Components.permanentlyHide((MarkupContainer)link, ID_ENTITY_FONT_AWESOME);
            } else {
                Label dummy = new Label(ID_ENTITY_FONT_AWESOME, (Serializable)((Object)""));
                link.addOrReplace(new Component[]{dummy});
                dummy.add(new Behavior[]{new CssClassAppender((String)cssClassFaFacet.value() + " fa-2x")});
                Components.permanentlyHide((MarkupContainer)link, ID_ENTITY_ICON);
            }
            String title = this.determineTitle();
            this.label = this.newLabel(ID_ENTITY_TITLE, this.titleAbbreviated(title));
            link.addOrReplace(new Component[]{this.label});
            String entityTypeName = adapterIfAny.getSpecification().getSingularName();
            link.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)(entityTypeName + ": " + title)))});
        }
        return link;
    }

    private AbstractLink createDynamicallyVisibleLink() {
        PageParameters pageParameters = ((ObjectAdapterModel)this.getModel()).getPageParametersWithoutUiHints();
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.ENTITY);
        return new BookmarkablePageLink<Void>(ID_ENTITY_LINK, pageClass, pageParameters){

            public boolean isVisible() {
                return ((ObjectAdapterModel)EntityIconAndTitlePanel.this.getModel()).getObject() != null;
            }
        };
    }

    private Label newLabel(String id, String title) {
        return new Label(id, (Serializable)((Object)title));
    }

    private String titleAbbreviated(String titleString) {
        int maxTitleLength = this.abbreviateTo((ObjectAdapterModel)this.getModel(), titleString);
        return EntityIconAndTitlePanel.abbreviated(titleString, maxTitleLength);
    }

    private String determineTitle() {
        ObjectAdapterModel model = (ObjectAdapterModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        return adapter != null ? adapter.titleString(this.getContextAdapterIfAny()) : "(no object)";
    }

    private int abbreviateTo(ObjectAdapterModel model, String titleString) {
        if (model.getRenderingHint().isInStandaloneTableTitleColumn()) {
            return this.getSettings().getMaxTitleLengthInStandaloneTables();
        }
        if (model.getRenderingHint().isInParentedTableTitleColumn()) {
            return this.getSettings().getMaxTitleLengthInParentedTables();
        }
        return titleString.length();
    }

    protected Image newImage(String id, ObjectAdapter adapter) {
        ResourceReference imageResource = this.imageCache.resourceReferenceFor(adapter);
        Image image = new Image(id, imageResource, new ResourceReference[0]){
            private static final long serialVersionUID = 1L;

            protected boolean shouldAddAntiCacheParameter() {
                return false;
            }
        };
        return image;
    }

    public ObjectAdapter getContextAdapterIfAny() {
        ObjectAdapterModel model = (ObjectAdapterModel)this.getModel();
        ObjectAdapterMemento contextAdapterMementoIfAny = model.getContextAdapterIfAny();
        return contextAdapterMementoIfAny != null ? contextAdapterMementoIfAny.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, this.isisSessionFactory.getCurrentSession().getPersistenceSession(), this.isisSessionFactory.getSpecificationLoader()) : null;
    }

    static String abbreviated(String str, int maxLength) {
        int length = str.length();
        if (length <= maxLength) {
            return str;
        }
        return maxLength <= 3 ? "" : str.substring(0, maxLength - 3) + "...";
    }

    protected PageClassRegistry getPageClassRegistry() {
        PageClassRegistryAccessor pcra = (PageClassRegistryAccessor)this.getApplication();
        return pcra.getPageClassRegistry();
    }

    protected ImageResourceCache getImageCache() {
        return this.imageCache;
    }

    @Override
    protected WicketViewerSettings getSettings() {
        return this.settings;
    }
}

