/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.header;

import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelUtil;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;

public class EntityHeaderPanel
extends PanelAbstract<EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_ACTIONS = "entityActions";

    public EntityHeaderPanel(String id, EntityModel entityModel) {
        super(id, entityModel);
    }

    public EntityModel getEntityModel() {
        return (EntityModel)this.getModel();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceIconAndTitle();
        this.buildEntityActionsGui();
    }

    private void addOrReplaceIconAndTitle() {
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_TITLE_AND_COPYLINK, (IModel<?>)this.getEntityModel());
        Component component = componentFactory.createComponent((IModel<?>)this.getEntityModel());
        this.addOrReplace(new Component[]{component});
    }

    private void buildEntityActionsGui() {
        EntityModel model = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        if (adapter != null) {
            List topLevelActions = ObjectAction.Util.findTopLevel((ObjectAdapter)adapter, (DeploymentCategory)this.getDeploymentCategory());
            List<LinkAndLabel> entityActionLinks = LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel(model, topLevelActions, null);
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)this, ID_ENTITY_ACTIONS, entityActionLinks, AdditionalLinksPanel.Style.INLINE_LIST);
        } else {
            this.permanentlyHide(ID_ENTITY_ACTIONS);
        }
    }
}

