/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.collection;

import java.io.Serializable;
import java.util.List;
import javax.inject.Provider;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EntityCollectionPanel
extends PanelAbstract<EntityModel>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_COLLECTION_GROUP = "collectionGroup";
    private static final String ID_COLLECTION_NAME = "collectionName";
    private static final String ID_COLLECTION = "collection";
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final ComponentHintKey selectedItemHintKey = ComponentHintKey.create(this.getSelectorDropdownPanel(), (String)"selectedItem");
    CollectionSelectorPanel selectorDropdownPanel;
    final WebMarkupContainer div = this.buildGui();
    private boolean visible = false;

    public EntityCollectionPanel(String id, EntityModel entityModel) {
        super(id, entityModel);
    }

    Provider<Component> getSelectorDropdownPanel() {
        return new SelectorDropDownPanelProvider();
    }

    public void onInitialize() {
        super.onInitialize();
        EntityCollectionPanel panel = this;
        if (this.visible) {
            panel.add(new Component[]{this.div});
        } else {
            Components.permanentlyHide((MarkupContainer)panel, this.div.getId());
        }
    }

    private WebMarkupContainer buildGui() {
        WebMarkupContainer div = new WebMarkupContainer(ID_COLLECTION_GROUP);
        EntityCollectionModel entityCollectionModel = EntityCollectionModel.createParented((EntityModel)((EntityModel)this.getModel()));
        CssClassAppender.appendCssClassTo((MarkupContainer)div, entityCollectionModel.getCollectionMemento().getId());
        CssClassAppender.appendCssClassTo((MarkupContainer)div, entityCollectionModel.getTypeOfSpecification().getFullIdentifier().replace('.', '-'));
        OneToManyAssociation association = entityCollectionModel.getCollectionMemento().getCollection(entityCollectionModel.getSpecificationLoader());
        ObjectAdapter objectAdapter = (ObjectAdapter)((EntityModel)this.getModel()).getObject();
        Consent visibility = association.isVisible(objectAdapter, InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        if (visibility.isAllowed()) {
            this.visible = true;
            CssClassFacet facet = (CssClassFacet)association.getFacet(CssClassFacet.class);
            if (facet != null) {
                String cssClass = facet.cssClass(objectAdapter);
                CssClassAppender.appendCssClassTo((MarkupContainer)div, cssClass);
            }
            CollectionPanel collectionPanel = this.newCollectionModel(ID_COLLECTION, entityCollectionModel);
            div.addOrReplace(new Component[]{collectionPanel});
            Label labelComponent = collectionPanel.createLabel(ID_COLLECTION_NAME, association.getName());
            NamedFacet namedFacet = (NamedFacet)association.getFacet(NamedFacet.class);
            labelComponent.setEscapeModelStrings(namedFacet == null || namedFacet.escaped());
            div.add(new Component[]{labelComponent});
            String description = association.getDescription();
            if (description != null) {
                labelComponent.add(new Behavior[]{new AttributeAppender("title", (IModel)Model.of((Serializable)((Object)description)))});
            }
            List links = entityCollectionModel.getLinks();
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)div, ID_ADDITIONAL_LINKS, links, AdditionalLinksPanel.Style.INLINE_LIST);
            CollectionSelectorHelper selectorHelper = new CollectionSelectorHelper(entityCollectionModel, this.getComponentFactoryRegistry(), this.selectedItemHintKey);
            List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
            if (componentFactories.size() <= 1) {
                this.permanentlyHide(ID_SELECTOR_DROPDOWN);
            } else {
                this.selectorDropdownPanel = new CollectionSelectorPanel(ID_SELECTOR_DROPDOWN, entityCollectionModel, this.selectedItemHintKey);
                Model componentFactoryModel = new Model();
                String selected = selectorHelper.honourViewHintElseDefault((Component)this.selectorDropdownPanel);
                ComponentFactory selectedComponentFactory = selectorHelper.find(selected);
                componentFactoryModel.setObject((Serializable)selectedComponentFactory);
                this.setOutputMarkupId(true);
                div.addOrReplace(new Component[]{this.selectorDropdownPanel});
                collectionPanel.setSelectorDropdownPanel(this.selectorDropdownPanel);
            }
        }
        return div;
    }

    protected CollectionPanel newCollectionModel(String id, EntityCollectionModel entityCollectionModel) {
        return new CollectionPanel(id, entityCollectionModel);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    private class SelectorDropDownPanelProvider
    implements Provider<Component>,
    Serializable {
        private SelectorDropDownPanelProvider() {
        }

        public Component get() {
            return EntityCollectionPanel.this.selectorDropdownPanel;
        }
    }
}

