/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.multiple;

import java.util.List;
import org.apache.isis.viewer.wicket.model.hints.IsisEnvelopeEvent;
import org.apache.isis.viewer.wicket.model.hints.IsisSelectorEvent;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.CssClassRemover;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

public class CollectionContentsMultipleViewsPanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final String INVISIBLE_CLASS = "link-selector-panel-invisible";
    private static final int MAX_NUM_UNDERLYING_VIEWS = 10;
    private static final String UIHINT_VIEW = "selectedItem";
    private final String underlyingIdPrefix = ComponentType.COLLECTION_CONTENTS.toString();
    private final CollectionSelectorHelper selectorHelper;
    private Component selectedComponent;
    private Component[] underlyingViews;

    public CollectionContentsMultipleViewsPanel(String id, EntityCollectionModel model) {
        super(id, model);
        EntityModel entityModel = model.getEntityModel();
        ComponentHintKey selectedItemSessionAttribute = entityModel != null ? ComponentHintKey.create((Component)this, (String)UIHINT_VIEW) : null;
        this.selectorHelper = new CollectionSelectorHelper(model, this.getComponentFactoryRegistry(), selectedItemSessionAttribute);
    }

    public void onInitialize() {
        super.onInitialize();
        this.addUnderlyingViews();
    }

    private void addUnderlyingViews() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        List<ComponentFactory> componentFactories = this.selectorHelper.getComponentFactories();
        CollectionSelectorPanel selectorDropdownPanelIfAny = CollectionSelectorProvider.Util.getCollectionSelectorProvider((Component)this);
        String selected = selectorDropdownPanelIfAny != null ? this.selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanelIfAny) : componentFactories.get(0).getName();
        int i = 0;
        int selectedIdx = 0;
        this.underlyingViews = new Component[10];
        EntityCollectionModel emptyModel = model.asDummy();
        for (ComponentFactory componentFactory : componentFactories) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            boolean isSelected = selected.equals(componentFactory.getName());
            Component underlyingView = componentFactory.createComponent(underlyingId, (IModel<?>)(isSelected ? model : emptyModel));
            if (isSelected) {
                selectedIdx = i;
            }
            this.underlyingViews[i++] = underlyingView;
            this.addOrReplace(new Component[]{underlyingView});
        }
        while (i < 10) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            this.permanentlyHide(underlyingId);
            ++i;
        }
        this.setOutputMarkupId(true);
        for (i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            if (i != selectedIdx) {
                component.add(new Behavior[]{new CssClassAppender(INVISIBLE_CLASS)});
                continue;
            }
            this.selectedComponent = component;
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        IsisSelectorEvent selectorEvent = (IsisSelectorEvent)IsisEnvelopeEvent.openLetter(event, IsisSelectorEvent.class);
        if (selectorEvent == null) {
            return;
        }
        CollectionSelectorPanel selectorDropdownPanel = CollectionSelectorProvider.Util.getCollectionSelectorProvider((Component)this);
        if (selectorDropdownPanel == null) {
            return;
        }
        String selectedView = selectorEvent.hintFor((Component)selectorDropdownPanel, UIHINT_VIEW);
        if (selectedView == null) {
            return;
        }
        int underlyingViewNum = this.selectorHelper.lookup(selectedView);
        EntityCollectionModel dummyModel = ((EntityCollectionModel)this.getModel()).asDummy();
        for (int i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            boolean isSelected = i == underlyingViewNum;
            CollectionContentsMultipleViewsPanel.applyCssVisibility(component, isSelected);
            component.setDefaultModel((IModel)(isSelected ? (EntityCollectionModel)this.getModel() : dummyModel));
        }
        this.selectedComponent = this.underlyingViews[underlyingViewNum];
        AjaxRequestTarget target = selectorEvent.getTarget();
        if (target != null) {
            target.add(new Component[]{this, selectorDropdownPanel});
        }
    }

    protected static void applyCssVisibility(Component component, boolean visible) {
        if (component == null) {
            return;
        }
        Object modifier = visible ? new CssClassRemover(INVISIBLE_CLASS) : new CssClassAppender(INVISIBLE_CLASS);
        component.add(new Behavior[]{modifier});
    }

    @Override
    public Integer getCount() {
        if (this.selectedComponent instanceof CollectionCountProvider) {
            CollectionCountProvider collectionCountProvider = (CollectionCountProvider)this.selectedComponent;
            return collectionCountProvider.getCount();
        }
        return null;
    }
}

