/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxPagingNavigator;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxNavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;

public class IsisAjaxNavigationToolbar
extends AjaxNavigationToolbar {
    private static final long serialVersionUID = 1L;
    private static final String ID_SHOW_ALL = "showAll";
    private static final String HINT_KEY_SHOW_ALL = "showAll";
    private final ObjectAdapterToggleboxColumn toggleboxColumn;

    public IsisAjaxNavigationToolbar(DataTable<?, ?> table, ObjectAdapterToggleboxColumn toggleboxColumn) {
        super(table);
        this.toggleboxColumn = toggleboxColumn;
        this.addShowAllButton(table);
    }

    private void addShowAllButton(final DataTable<?, ?> table) {
        table.setOutputMarkupId(true);
        ((MarkupContainer)this.get("span")).add(new Component[]{new AjaxLink("showAll"){

            public void onClick(AjaxRequestTarget target) {
                UiHintContainer hintContainer;
                IsisAjaxNavigationToolbar.this.showAllItemsOn(table);
                DataTable dataTable = IsisAjaxNavigationToolbar.this.getTable();
                CollectionContentsSortableDataProvider dataProvider = (CollectionContentsSortableDataProvider)dataTable.getDataProvider();
                EntityCollectionModel collectionModel = dataProvider.getEntityCollectionModel();
                if (IsisAjaxNavigationToolbar.this.toggleboxColumn != null) {
                    collectionModel.clearToggleMementosList();
                    IsisAjaxNavigationToolbar.this.toggleboxColumn.clearToggles();
                }
                if ((hintContainer = IsisAjaxNavigationToolbar.this.getUiHintContainer()) != null) {
                    hintContainer.setHint((Component)table, "showAll", "true");
                }
                target.add(new Component[]{table});
            }
        }});
    }

    protected PagingNavigator newPagingNavigator(String navigatorId, DataTable<?, ?> table) {
        return new IsisAjaxPagingNavigator(navigatorId, (IPageable)table);
    }

    void honourSortOrderHints() {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        DataTable table = this.getTable();
        String showAll = uiHintContainer.getHint((Component)table, "showAll");
        if (showAll != null) {
            this.showAllItemsOn(table);
        }
    }

    private void showAllItemsOn(DataTable<?, ?> table) {
        table.setItemsPerPage(Long.MAX_VALUE);
    }

    private UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this, EntityModel.class);
    }
}

