/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectVisibilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;

public class CollectionContentsSortableDataProvider
extends SortableDataProvider<ObjectAdapter, String> {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel model;
    private static Ordering<ObjectAdapter> ORDERING_BY_NATURAL = new Ordering<ObjectAdapter>(){

        public int compare(ObjectAdapter p, ObjectAdapter q) {
            Object pPojo = p.getObject();
            Object qPojo = q.getObject();
            if (!(pPojo instanceof Comparable) || !(qPojo instanceof Comparable)) {
                return 0;
            }
            return this.naturalOrdering(pPojo, qPojo);
        }

        private int naturalOrdering(Object pPojo, Object qPojo) {
            Comparable pComparable = (Comparable)pPojo;
            Comparable qComparable = (Comparable)qPojo;
            return Ordering.natural().compare((Object)pComparable, (Object)qComparable);
        }
    };

    public CollectionContentsSortableDataProvider(EntityCollectionModel model) {
        this.model = model;
    }

    public IModel<ObjectAdapter> model(ObjectAdapter adapter) {
        return new EntityModel(adapter);
    }

    public long size() {
        return ((List)this.model.getObject()).size();
    }

    public void detach() {
        super.detach();
        this.model.detach();
    }

    public EntityCollectionModel getEntityCollectionModel() {
        return this.model;
    }

    public Iterator<ObjectAdapter> iterator(long first, long count) {
        List adapters = (List)this.model.getObject();
        Iterable visibleAdapters = Iterables.filter((Iterable)adapters, this.ignoreHidden());
        List<ObjectAdapter> sortedVisibleAdapters = this.sortedCopy(visibleAdapters, (SortParam<String>)this.getSort());
        List<ObjectAdapter> pagedAdapters = CollectionContentsSortableDataProvider.subList(first, count, sortedVisibleAdapters);
        return pagedAdapters.iterator();
    }

    private static List<ObjectAdapter> subList(long first, long count, List<ObjectAdapter> objectAdapters) {
        int fromIndex = (int)first;
        int toIndex = Math.min((int)(first + count), objectAdapters.size());
        return objectAdapters.subList(fromIndex, toIndex);
    }

    private List<ObjectAdapter> sortedCopy(Iterable<ObjectAdapter> adapters, SortParam<String> sort) {
        ObjectAssociation sortProperty = this.lookupAssociationFor(sort);
        if (sortProperty == null) {
            return Lists.newArrayList(adapters);
        }
        Ordering<ObjectAdapter> ordering = CollectionContentsSortableDataProvider.orderingBy(sortProperty, sort.isAscending());
        return ordering.sortedCopy(adapters);
    }

    private ObjectAssociation lookupAssociationFor(SortParam<String> sort) {
        if (sort == null) {
            return null;
        }
        ObjectSpecification elementSpec = this.model.getTypeOfSpecification();
        String sortPropertyId = (String)sort.getProperty();
        try {
            return elementSpec.getAssociation(sortPropertyId);
        }
        catch (ObjectSpecificationException ex) {
            return null;
        }
    }

    private Predicate<ObjectAdapter> ignoreHidden() {
        return new Predicate<ObjectAdapter>(){

            public boolean apply(ObjectAdapter input) {
                InteractionResult visibleResult = InteractionUtils.isVisibleResult((FacetHolder)input.getSpecification(), (VisibilityContext)CollectionContentsSortableDataProvider.this.createVisibleInteractionContext(input));
                return visibleResult.isNotVetoing();
            }
        };
    }

    private VisibilityContext<?> createVisibleInteractionContext(ObjectAdapter objectAdapter) {
        return new ObjectVisibilityContext(objectAdapter, objectAdapter.getSpecification().getIdentifier(), InteractionInitiatedBy.USER, Where.ALL_TABLES);
    }

    private static Ordering<ObjectAdapter> orderingBy(final ObjectAssociation sortProperty, final boolean ascending) {
        Ordering<ObjectAdapter> ordering = new Ordering<ObjectAdapter>(){

            public int compare(ObjectAdapter p, ObjectAdapter q) {
                ObjectAdapter pSort = sortProperty.get(p, InteractionInitiatedBy.FRAMEWORK);
                ObjectAdapter qSort = sortProperty.get(q, InteractionInitiatedBy.FRAMEWORK);
                Ordering naturalOrdering = ascending ? ORDERING_BY_NATURAL.nullsFirst() : ORDERING_BY_NATURAL.reverse().nullsLast();
                return naturalOrdering.compare((Object)pSort, (Object)qSort);
            }
        };
        return ordering;
    }
}

