/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.services.tablecol.TableColumnOrderService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.common.OnConcurrencyExceptionHandler;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.components.collection.bulk.BulkActionsProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxFallbackDataTable;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterPropertyColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterTitleColumn;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CollectionContentsAsAjaxTablePanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE = "table";
    private IsisAjaxFallbackDataTable<ObjectAdapter, String> dataTable;

    public CollectionContentsAsAjaxTablePanel(String id, EntityCollectionModel model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        ArrayList columns = Lists.newArrayList();
        BulkActionsProvider bulkActionsProvider = this.getBulkActionsProvider();
        ObjectAdapterToggleboxColumn toggleboxColumn = null;
        if (bulkActionsProvider != null) {
            toggleboxColumn = bulkActionsProvider.getToggleboxColumn();
            if (toggleboxColumn != null) {
                columns.add(toggleboxColumn);
            }
            bulkActionsProvider.configureBulkActions(toggleboxColumn);
        }
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        this.addTitleColumn(columns, model.getParentObjectAdapterMemento(), this.getSettings().getMaxTitleLengthInStandaloneTables(), this.getSettings().getMaxTitleLengthInStandaloneTables());
        this.addPropertyColumnsIfRequired(columns);
        CollectionContentsSortableDataProvider dataProvider = new CollectionContentsSortableDataProvider(model);
        this.dataTable = new IsisAjaxFallbackDataTable(ID_TABLE, columns, dataProvider, model.getPageSize(), toggleboxColumn);
        this.addOrReplace(new Component[]{this.dataTable});
        this.dataTable.honourHints();
        if (toggleboxColumn != null) {
            OnConcurrencyExceptionHandler handler2 = new OnConcurrencyExceptionHandler(){
                private static final long serialVersionUID = 1L;

                public void onConcurrencyException(Component context, ObjectAdapter selectedAdapter, ConcurrencyException ex, AjaxRequestTarget ajaxRequestTarget) {
                    ajaxRequestTarget.add(new Component[]{CollectionContentsAsAjaxTablePanel.this.dataTable});
                }
            };
            toggleboxColumn.setOnConcurrencyExceptionHandler(handler2);
        }
    }

    private BulkActionsProvider getBulkActionsProvider() {
        for (CollectionContentsAsAjaxTablePanel component = this; component != null; component = component.getParent()) {
            if (!(component instanceof BulkActionsProvider)) continue;
            return (BulkActionsProvider)((Object)component);
        }
        return null;
    }

    private void addTitleColumn(List<IColumn<ObjectAdapter, String>> columns, ObjectAdapterMemento parentAdapterMementoIfAny, int maxTitleParented, int maxTitleStandalone) {
        int maxTitleLength = ((EntityCollectionModel)this.getModel()).isParented() ? maxTitleParented : maxTitleStandalone;
        columns.add((IColumn<ObjectAdapter, String>)new ObjectAdapterTitleColumn(parentAdapterMementoIfAny, maxTitleLength));
    }

    private void addPropertyColumnsIfRequired(List<IColumn<ObjectAdapter, String>> columns) {
        ObjectSpecification typeOfSpec = ((EntityCollectionModel)this.getModel()).getTypeOfSpecification();
        GridFacet gridFacet = (GridFacet)typeOfSpec.getFacet(GridFacet.class);
        if (gridFacet != null) {
            Grid grid = gridFacet.getGrid();
        }
        Where whereContext = ((EntityCollectionModel)this.getModel()).isParented() ? Where.PARENTED_TABLES : Where.STANDALONE_TABLES;
        ObjectSpecification parentSpecIfAny = ((EntityCollectionModel)this.getModel()).isParented() ? ((EntityCollectionModel)this.getModel()).getParentObjectAdapterMemento().getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader()).getSpecification() : null;
        Filter filter = Filters.and((Filter[])new Filter[]{ObjectAssociation.Filters.PROPERTIES, ObjectAssociation.Filters.staticallyVisible((Where)whereContext), CollectionContentsAsAjaxTablePanel.associationDoesNotReferenceParent(parentSpecIfAny)});
        List propertyList = typeOfSpec.getAssociations(Contributed.INCLUDED, filter);
        LinkedHashMap propertyById = Maps.newLinkedHashMap();
        for (ObjectAssociation property : propertyList) {
            propertyById.put(property.getId(), property);
        }
        List<Object> propertyIds = Lists.newArrayList(propertyById.keySet());
        List tableColumnOrderServices = this.getServicesInjector().lookupServices(TableColumnOrderService.class);
        for (TableColumnOrderService tableColumnOrderService : tableColumnOrderServices) {
            List<String> propertyReorderedIds = this.reordered(tableColumnOrderService, propertyIds);
            if (propertyReorderedIds == null) continue;
            propertyIds = propertyReorderedIds;
            break;
        }
        for (String propertyId : propertyIds) {
            ObjectAssociation property = (ObjectAssociation)propertyById.get(propertyId);
            if (property == null) continue;
            ObjectAdapterPropertyColumn nopc = this.createObjectAdapterPropertyColumn(property);
            columns.add((IColumn<ObjectAdapter, String>)nopc);
        }
    }

    private List<String> reordered(TableColumnOrderService tableColumnOrderService, List<String> propertyIds) {
        Class collectionType = ((EntityCollectionModel)this.getModel()).getTypeOfSpecification().getCorrespondingClass();
        ObjectAdapterMemento parentObjectAdapterMemento = ((EntityCollectionModel)this.getModel()).getParentObjectAdapterMemento();
        if (parentObjectAdapterMemento != null) {
            ObjectAdapter parentObjectAdapter = parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader());
            Object parent = parentObjectAdapter.getObject();
            String collectionId = ((EntityCollectionModel)this.getModel()).getCollectionMemento().getId();
            return tableColumnOrderService.orderParented(parent, collectionId, collectionType, propertyIds);
        }
        return tableColumnOrderService.orderStandalone(collectionType, propertyIds);
    }

    static Filter<ObjectAssociation> associationDoesNotReferenceParent(final ObjectSpecification parentSpec) {
        if (parentSpec == null) {
            return Filters.any();
        }
        return new Filter<ObjectAssociation>(){

            public boolean accept(ObjectAssociation association) {
                HiddenFacet facet = (HiddenFacet)association.getFacet(HiddenFacet.class);
                if (facet == null) {
                    return true;
                }
                if (facet.where() != Where.REFERENCES_PARENT) {
                    return true;
                }
                ObjectSpecification assocSpec = association.getSpecification();
                boolean associationSpecIsOfParentSpec = parentSpec.isOfType(assocSpec);
                boolean isVisible = !associationSpecIsOfParentSpec;
                return isVisible;
            }
        };
    }

    private ObjectAdapterPropertyColumn createObjectAdapterPropertyColumn(ObjectAssociation property) {
        NamedFacet facet = (NamedFacet)property.getFacet(NamedFacet.class);
        boolean escaped = facet == null || facet.escaped();
        String parentTypeName = property.getOnType().getSpecId().asString();
        return new ObjectAdapterPropertyColumn(((EntityCollectionModel)this.getModel()).getType(), (IModel<String>)Model.of((Serializable)((Object)property.getName())), property.getId(), property.getId(), escaped, parentTypeName);
    }

    protected void onModelChanged() {
        this.buildGui();
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getCount();
    }
}

