/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.selector;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.facets.members.render.RenderFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsAsAjaxTablePanelFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.multiple.CollectionContentsMultipleViewsPanelFactory;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class CollectionSelectorHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String UIHINT_EVENT_VIEW_KEY = "selectedItem";
    private final EntityCollectionModel model;
    private final List<ComponentFactory> componentFactories;
    private final ComponentHintKey componentHintKey;

    public CollectionSelectorHelper(EntityCollectionModel model, ComponentFactoryRegistry componentFactoryRegistry) {
        this(model, componentFactoryRegistry, ComponentHintKey.noop());
    }

    public CollectionSelectorHelper(EntityCollectionModel model, ComponentFactoryRegistry componentFactoryRegistry, ComponentHintKey componentHintKey) {
        this.model = model;
        this.componentFactories = this.locateComponentFactories(componentFactoryRegistry);
        this.componentHintKey = componentHintKey != null ? componentHintKey : ComponentHintKey.noop();
    }

    private List<ComponentFactory> locateComponentFactories(ComponentFactoryRegistry componentFactoryRegistry) {
        List<ComponentFactory> componentFactories = componentFactoryRegistry.findComponentFactories(ComponentType.COLLECTION_CONTENTS, (IModel<?>)this.model);
        ArrayList otherFactories = Lists.newArrayList((Iterable)Collections2.filter(componentFactories, (Predicate)new Predicate<ComponentFactory>(){

            public boolean apply(ComponentFactory input) {
                return input.getClass() != CollectionContentsMultipleViewsPanelFactory.class;
            }
        }));
        return CollectionSelectorHelper.ordered(otherFactories);
    }

    public List<ComponentFactory> getComponentFactories() {
        return this.componentFactories;
    }

    public String honourViewHintElseDefault(Component component) {
        String viewStr;
        UiHintContainer hintContainer = CollectionSelectorHelper.getUiHintContainer(component);
        if (hintContainer != null && (viewStr = hintContainer.getHint(component, UIHINT_EVENT_VIEW_KEY)) != null) {
            return viewStr;
        }
        String initialFactory = this.determineInitialFactory();
        if (hintContainer != null) {
            hintContainer.setHint(component, UIHINT_EVENT_VIEW_KEY, initialFactory);
        }
        return initialFactory;
    }

    private String determineInitialFactory() {
        String defaultView;
        Bookmark bookmark = this.bookmarkHintIfAny();
        String sessionAttribute = this.componentHintKey.get(bookmark);
        if (sessionAttribute != null) {
            return sessionAttribute;
        }
        CollectionLayoutData layoutData = this.model.getLayoutData();
        if (layoutData != null && (defaultView = layoutData.getDefaultView()) != null) {
            return defaultView;
        }
        if (CollectionSelectorHelper.hasDefaultViewFacet(this.model)) {
            DefaultViewFacet defaultViewFacet = (DefaultViewFacet)this.model.getCollectionMemento().getCollection(this.model.getSpecificationLoader()).getFacet(DefaultViewFacet.class);
            for (ComponentFactory componentFactory : this.componentFactories) {
                String viewName;
                String componentName = componentFactory.getName();
                if (!componentName.equalsIgnoreCase(viewName = (String)defaultViewFacet.value())) continue;
                return componentName;
            }
        }
        return CollectionSelectorHelper.hasRenderEagerlyFacet(this.model) || this.model.isStandalone() ? "table" : "hidden";
    }

    private Bookmark bookmarkHintIfAny() {
        EntityModel entityModel = this.model.getEntityModel();
        return entityModel != null ? entityModel.getObjectAdapterMemento().asHintingBookmark() : null;
    }

    private static List<ComponentFactory> ordered(List<ComponentFactory> componentFactories) {
        return CollectionSelectorHelper.orderAjaxTableToEnd(componentFactories);
    }

    static List<ComponentFactory> orderAjaxTableToEnd(List<ComponentFactory> componentFactories) {
        int ajaxTableIdx = CollectionSelectorHelper.findAjaxTable(componentFactories);
        if (ajaxTableIdx >= 0) {
            ArrayList orderedFactories = Lists.newArrayList(componentFactories);
            ComponentFactory ajaxTableFactory = (ComponentFactory)orderedFactories.remove(ajaxTableIdx);
            orderedFactories.add(ajaxTableFactory);
            return orderedFactories;
        }
        return componentFactories;
    }

    private static int findAjaxTable(List<ComponentFactory> componentFactories) {
        for (int i = 0; i < componentFactories.size(); ++i) {
            if (!(componentFactories.get(i) instanceof CollectionContentsAsAjaxTablePanelFactory)) continue;
            return i;
        }
        return -1;
    }

    private static UiHintContainer getUiHintContainer(Component component) {
        return UiHintContainer.Util.hintContainerOf((Component)component, EntityCollectionModel.class);
    }

    private static boolean hasRenderEagerlyFacet(IModel<?> model) {
        EntityCollectionModel entityCollectionModel = CollectionSelectorHelper.toEntityCollectionModel(model);
        if (entityCollectionModel == null) {
            return false;
        }
        OneToManyAssociation collection = entityCollectionModel.getCollectionMemento().getCollection(entityCollectionModel.getSpecificationLoader());
        RenderFacet renderFacet = (RenderFacet)collection.getFacet(RenderFacet.class);
        return renderFacet != null && renderFacet.value() == Render.Type.EAGERLY;
    }

    private static boolean hasDefaultViewFacet(IModel<?> model) {
        EntityCollectionModel entityCollectionModel = CollectionSelectorHelper.toEntityCollectionModel(model);
        if (entityCollectionModel == null) {
            return false;
        }
        OneToManyAssociation collection = entityCollectionModel.getCollectionMemento().getCollection(entityCollectionModel.getSpecificationLoader());
        DefaultViewFacet defaultViewFacet = (DefaultViewFacet)collection.getFacet(DefaultViewFacet.class);
        return defaultViewFacet != null;
    }

    private static EntityCollectionModel toEntityCollectionModel(IModel<?> model) {
        if (!(model instanceof EntityCollectionModel)) {
            return null;
        }
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)model;
        if (!entityCollectionModel.isParented()) {
            return null;
        }
        return entityCollectionModel;
    }

    public ComponentFactory find(String selected) {
        ComponentFactory componentFactory = this.doFind(selected);
        if (componentFactory != null) {
            return componentFactory;
        }
        EntityCollectionModel entityCollectionModel = this.model;
        String fallback = entityCollectionModel.isParented() ? "hidden" : "table";
        componentFactory = this.doFind(fallback);
        if (componentFactory == null) {
            throw new IllegalStateException(String.format("Could not locate '%s' (as the fallback collection panel)", fallback));
        }
        return componentFactory;
    }

    private ComponentFactory doFind(String selected) {
        for (ComponentFactory componentFactory : this.componentFactories) {
            if (!selected.equals(componentFactory.getName())) continue;
            return componentFactory;
        }
        return null;
    }

    public int lookup(String view) {
        int i = 0;
        for (ComponentFactory componentFactory : this.componentFactories) {
            if (view.equals(componentFactory.getName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

