/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.bulk;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.annotation.InvokedOn;
import org.apache.isis.applib.services.actinvoc.ActionInvocationContext;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.ToggledMementosProvider;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseType;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ObjectAdapterToggleboxColumn;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;

public final class BulkActionsLinkFactory
implements ActionLinkFactory {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel model;
    private final ObjectAdapterToggleboxColumn toggleboxColumn;

    public BulkActionsLinkFactory(EntityCollectionModel model, ObjectAdapterToggleboxColumn toggleboxColumn) {
        this.model = model;
        this.toggleboxColumn = toggleboxColumn;
    }

    @Override
    public LinkAndLabel newLink(ObjectAction objectAction, String linkId, ToggledMementosProvider toggledMementosProviderIfAny) {
        final ActionMemento actionMemento = new ActionMemento(objectAction);
        Link<Object> link = new Link<Object>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                ObjectAction objectAction = actionMemento.getAction(BulkActionsLinkFactory.this.getSpecificationLoader());
                AdapterManager.ConcurrencyChecking concurrencyChecking = AdapterManager.ConcurrencyChecking.concurrencyCheckingFor((ActionSemantics.Of)objectAction.getSemantics());
                try {
                    Bulk.InteractionContext bulkInteractionContext;
                    List toggleMementosList = BulkActionsLinkFactory.this.model.getToggleMementosList();
                    ImmutableList toggledAdapters = FluentIterable.from((Iterable)toggleMementosList).transform(ObjectAdapterMemento.Functions.fromMemento((AdapterManager.ConcurrencyChecking)concurrencyChecking, (PersistenceSession)BulkActionsLinkFactory.this.getPersistenceSession(), (SpecificationLoader)BulkActionsLinkFactory.this.getSpecificationLoader())).toList();
                    ArrayList domainObjects = Lists.newArrayList((Iterable)Iterables.transform((Iterable)toggledAdapters, (Function)ObjectAdapter.Functions.getObject()));
                    ActionInvocationContext actionInvocationContext = (ActionInvocationContext)BulkActionsLinkFactory.this.getServicesInjector().lookupService(ActionInvocationContext.class);
                    if (actionInvocationContext != null) {
                        actionInvocationContext.setInvokedOn(InvokedOn.COLLECTION);
                        actionInvocationContext.setDomainObjects((List)domainObjects);
                    }
                    if ((bulkInteractionContext = (Bulk.InteractionContext)BulkActionsLinkFactory.this.getServicesInjector().lookupService(Bulk.InteractionContext.class)) != null) {
                        bulkInteractionContext.setInvokedAs(Bulk.InteractionContext.InvokedAs.BULK);
                        bulkInteractionContext.setDomainObjects((List)domainObjects);
                    }
                    ObjectAdapter lastReturnedAdapter = null;
                    int i = 0;
                    for (ObjectAdapter adapter : toggledAdapters) {
                        int numParameters;
                        CommandContext commandContext = (CommandContext)BulkActionsLinkFactory.this.getServicesInjector().lookupService(CommandContext.class);
                        if (commandContext != null) {
                            Command command = commandContext.getCommand();
                            command.setExecutor(Command.Executor.USER);
                        }
                        if ((numParameters = objectAction.getParameterCount()) != 0) {
                            return;
                        }
                        if (bulkInteractionContext != null) {
                            bulkInteractionContext.setIndex(i++);
                        }
                        ObjectAdapter mixedInAdapter = null;
                        ObjectAdapter[] arguments = new ObjectAdapter[]{};
                        lastReturnedAdapter = objectAction.executeWithRuleChecking(adapter, mixedInAdapter, arguments, InteractionInitiatedBy.USER, ActionModel.WHERE_FOR_ACTION_INVOCATION);
                        TransactionService transactionService = (TransactionService)BulkActionsLinkFactory.this.getServicesInjector().lookupService(TransactionService.class);
                        transactionService.nextTransaction();
                    }
                    BulkActionsLinkFactory.this.model.clearToggleMementosList();
                    BulkActionsLinkFactory.this.toggleboxColumn.clearToggles();
                    ActionModel actionModel = BulkActionsLinkFactory.this.model.getActionModelHint();
                    if (actionModel != null && actionModel.getActionMemento().getAction(BulkActionsLinkFactory.this.getSpecificationLoader()).getSemantics().isIdempotentInNature()) {
                        actionModel.detach();
                        ObjectAdapter resultAdapter = (ObjectAdapter)actionModel.getObject();
                        BulkActionsLinkFactory.this.model.setObjectList(resultAdapter);
                    } else {
                        BulkActionsLinkFactory.this.model.setObject(this.persistentAdaptersWithin((List)BulkActionsLinkFactory.this.model.getObject()));
                    }
                    if (lastReturnedAdapter != null) {
                        ActionResultResponse resultResponse = ActionResultResponseType.determineAndInterpretResult(actionModel, null, lastReturnedAdapter);
                        resultResponse.getHandlingStrategy().handleResults(resultResponse, BulkActionsLinkFactory.this.model.getIsisSessionFactory());
                    }
                }
                catch (ConcurrencyException ex) {
                    this.recover();
                    BulkActionsLinkFactory.this.getMessageBroker().addWarning(ex.getMessage());
                    return;
                }
                catch (RuntimeException ex) {
                    RecoverableException appEx = RecoverableException.Util.getRecoverableExceptionIfAny((Exception)ex);
                    if (appEx != null) {
                        this.recover();
                        BulkActionsLinkFactory.this.getMessageBroker().setApplicationError(appEx.getMessage());
                        return;
                    }
                    throw ex;
                }
            }

            private void recover() {
                ArrayList toggleMementosList = Lists.newArrayList((Iterable)BulkActionsLinkFactory.this.model.getToggleMementosList());
                for (ObjectAdapterMemento oam : toggleMementosList) {
                    oam.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, BulkActionsLinkFactory.this.getPersistenceSession(), BulkActionsLinkFactory.this.getSpecificationLoader());
                }
                BulkActionsLinkFactory.this.model.setObject(this.persistentAdaptersWithin((List)BulkActionsLinkFactory.this.model.getObject()));
                List adapters = (List)BulkActionsLinkFactory.this.model.getObject();
                BulkActionsLinkFactory.this.model.clearToggleMementosList();
                for (ObjectAdapterMemento oam : toggleMementosList) {
                    ObjectAdapter objectAdapter = oam.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, BulkActionsLinkFactory.this.getPersistenceSession(), BulkActionsLinkFactory.this.getSpecificationLoader());
                    if (!adapters.contains(objectAdapter)) continue;
                    BulkActionsLinkFactory.this.model.toggleSelectionOn(objectAdapter);
                }
            }

            private List<ObjectAdapter> persistentAdaptersWithin(List<ObjectAdapter> adapters) {
                return Lists.newArrayList((Iterable)Iterables.filter(adapters, (Predicate)new Predicate<ObjectAdapter>(){

                    public boolean apply(ObjectAdapter input) {
                        return !input.isTransient() && !input.isDestroyed();
                    }
                }));
            }
        };
        link.add(new Behavior[]{new JGrowlBehaviour()});
        String disabledReasonIfAny = null;
        boolean blobOrClob = false;
        ObjectAdapter objectAdapter = null;
        return LinkAndLabel.newLinkAndLabel(objectAdapter, (ObjectAction)objectAction, (AbstractLink)link, disabledReasonIfAny, (boolean)false);
    }

    SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }

    PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.getIsisSessionFactory().getCurrentSession().getAuthenticationSession();
    }

    protected MessageBroker getMessageBroker() {
        return this.getAuthenticationSession().getMessageBroker();
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    private IsisSessionFactory getIsisSessionFactory() {
        return this.model.getIsisSessionFactory();
    }
}

