/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.bulk;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;

public class BulkActionsHelper
implements Serializable {
    private final EntityCollectionModel collectionModel;
    private static final long serialVersionUID = 1L;

    public BulkActionsHelper(EntityCollectionModel collectionModel) {
        this.collectionModel = collectionModel;
    }

    public List<ObjectAction> getBulkActions(IsisSessionFactory isisSessionFactory) {
        if (this.collectionModel.isParented()) {
            return Collections.emptyList();
        }
        ObjectSpecification objectSpec = this.getObjectSpecification(isisSessionFactory);
        List<ActionType> actionTypes = this.inferActionTypes(isisSessionFactory);
        List objectActions = objectSpec.getObjectActions(actionTypes, Contributed.INCLUDED, Filters.any());
        return FluentIterable.from((Iterable)objectActions).filter(ObjectAction.Predicates.bulk()).toList();
    }

    private ObjectSpecification getObjectSpecification(IsisSessionFactory isisSessionFactory) {
        return this.collectionModel.getTypeOfSpecification();
    }

    private List<ActionType> inferActionTypes(IsisSessionFactory isisSessionFactory) {
        ArrayList actionTypes = Lists.newArrayList();
        actionTypes.add(ActionType.USER);
        DeploymentCategory deploymentCategory = isisSessionFactory.getDeploymentCategory();
        if (!deploymentCategory.isProduction()) {
            actionTypes.add(ActionType.PROTOTYPE);
        }
        return actionTypes;
    }
}

