/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;

public class AssociatedWithActionsHelper
implements Serializable {
    private final EntityCollectionModel collectionModel;

    public AssociatedWithActionsHelper(EntityCollectionModel collectionModel) {
        this.collectionModel = collectionModel;
    }

    public List<ObjectAction> getAssociatedActions(IsisSessionFactory isisSessionFactory) {
        if (this.collectionModel.isStandalone()) {
            return Collections.emptyList();
        }
        OneToManyAssociation collection = this.collectionModel.getCollectionMemento().getCollection(isisSessionFactory.getSpecificationLoader());
        ObjectSpecification objectSpec = this.getObjectSpecification(isisSessionFactory);
        List<ActionType> actionTypes = AssociatedWithActionsHelper.inferActionTypes(isisSessionFactory);
        List objectActions = objectSpec.getObjectActions(actionTypes, Contributed.INCLUDED, Filters.any());
        return FluentIterable.from((Iterable)objectActions).filter(ObjectAction.Predicates.associatedWithAndWithCollectionParameterFor((OneToManyAssociation)collection)).toList();
    }

    private ObjectSpecification getObjectSpecification(IsisSessionFactory isisSessionFactory) {
        ObjectAdapterMemento parentOam = this.collectionModel.getParentObjectAdapterMemento();
        ObjectAdapter parentAdapter = parentOam.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK, isisSessionFactory.getCurrentSession().getPersistenceSession(), isisSessionFactory.getSpecificationLoader());
        return parentAdapter.getSpecification();
    }

    private static List<ActionType> inferActionTypes(IsisSessionFactory isisSessionFactory) {
        ArrayList actionTypes = Lists.newArrayList();
        actionTypes.add(ActionType.USER);
        DeploymentCategory deploymentCategory = isisSessionFactory.getDeploymentCategory();
        if (!deploymentCategory.isProduction()) {
            actionTypes.add(ActionType.PROTOTYPE);
        }
        return actionTypes;
    }
}

