/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import java.io.Serializable;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseType;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionFormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ActionParametersPanel
extends PanelAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_ACTION_NAME = "actionName";
    private boolean showHeader = true;

    public ActionParametersPanel(String id, ActionModel actionModel) {
        super(id, actionModel);
    }

    ActionModel getActionModel() {
        return (ActionModel)super.getModel();
    }

    public void setActionPrompt(ActionPrompt actionPrompt) {
        ActionFormExecutorStrategy formExecutor = new ActionFormExecutorStrategy(this.getActionModel());
        formExecutor.setActionPrompt(actionPrompt);
    }

    protected void onInitialize() {
        super.onInitialize();
        ActionModel actionModel = (ActionModel)this.getModel();
        if (!actionModel.hasParameters()) {
            throw new IllegalStateException("model has no parameters!");
        }
        WebMarkupContainer header = new WebMarkupContainer(ID_HEADER){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ActionParametersPanel.this.showHeader);
            }
        };
        this.addOrReplace(new Component[]{header});
        ObjectAdapter targetAdapter = null;
        try {
            targetAdapter = actionModel.getTargetAdapter();
            this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.PARAMETERS, (IModel<?>)this.getActionModel());
            this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)actionModel.getParentEntityModel());
            String actionName = this.getActionModel().getActionMemento().getAction(actionModel.getSpecificationLoader()).getName();
            header.add(new Component[]{new Label(ID_ACTION_NAME, (IModel)Model.of((Serializable)((Object)actionName)))});
        }
        catch (ConcurrencyException ex) {
            if (targetAdapter == null) {
                targetAdapter = ((ActionModel)this.getModel()).getTargetAdapter();
            }
            ActionResultResponse resultResponse = ActionResultResponseType.OBJECT.interpretResult(this.getActionModel(), targetAdapter, ex);
            resultResponse.getHandlingStrategy().handleResults(resultResponse, this.getIsisSessionFactory());
            MessageService messageService = (MessageService)this.getServicesInjector().lookupService(MessageService.class);
            messageService.warnUser(ex.getMessage());
        }
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }
}

