/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import java.util.List;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.wicket.model.hints.IsisActionCompletedEvent;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionArgumentModel;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionFormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.components.scalars.PanelWithChoices;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorStrategy;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.panels.PromptFormAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;

class ActionParametersForm
extends PromptFormAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;

    public ActionParametersForm(String id, Component parentPanel, WicketViewerSettings settings, ActionModel actionModel) {
        super(id, parentPanel, settings, actionModel);
    }

    private ActionModel getActionModel() {
        return (ActionModel)super.getModel();
    }

    @Override
    protected void addParameters() {
        ActionModel actionModel = this.getActionModel();
        RepeatingView rv = new RepeatingView("parameters");
        this.add(new Component[]{rv});
        this.paramPanels.clear();
        List parameterMementos = actionModel.primeArgumentModels();
        for (ActionParameterMemento apm : parameterMementos) {
            WebMarkupContainer container = new WebMarkupContainer(rv.newChildId());
            rv.add(new Component[]{container});
            ActionArgumentModel actionArgumentModel = actionModel.getArgumentModel(apm);
            actionArgumentModel.setActionArgsHint(actionModel.getArgumentsAsArray());
            ScalarPanelAbstract2 paramPanel = this.newParamPanel(container, actionArgumentModel);
            this.paramPanels.add(paramPanel);
        }
    }

    private ScalarPanelAbstract2 newParamPanel(WebMarkupContainer container, ActionArgumentModel model) {
        ScalarPanelAbstract2 paramPanel;
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)model);
        if (component instanceof MarkupContainer) {
            MarkupContainer markupContainer = (MarkupContainer)component;
            ObjectActionParameter actionParameter = model.getParameterMemento().getActionParameter(this.getSpecificationLoader());
            ObjectAction action = actionParameter.getAction();
            String objectSpecId = action.getOnType().getSpecId().asString().replace(".", "-");
            String parmId = actionParameter.getId();
            String css = "isis-" + objectSpecId + "-" + action.getId() + "-" + parmId;
            CssClassAppender.appendCssClassTo(markupContainer, CssClassAppender.asCssStyle(css));
        }
        ScalarPanelAbstract2 scalarPanelAbstract2 = paramPanel = component instanceof ScalarPanelAbstract2 ? (ScalarPanelAbstract2)component : null;
        if (paramPanel != null) {
            paramPanel.setOutputMarkupId(true);
            paramPanel.notifyOnChange(this);
        }
        return paramPanel;
    }

    @Override
    protected Object newCompletedEvent(AjaxRequestTarget target, Form<?> form) {
        return new IsisActionCompletedEvent(this.getActionModel(), target, form);
    }

    @Override
    protected void doConfigureOkButton(AjaxButton okButton) {
        this.applyAreYouSure(okButton);
    }

    private void applyAreYouSure(AjaxButton button) {
        ActionModel actionModel = this.getActionModel();
        ObjectAction action = actionModel.getActionMemento().getAction(this.getSpecificationLoader());
        SemanticsOf semanticsOf = SemanticsOf.from((ActionSemantics.Of)action.getSemantics());
        ServicesInjector servicesInjector = this.getPersistenceSession().getServicesInjector();
        PanelUtil.addConfirmationDialogIfAreYouSureSemantics((Component)button, semanticsOf, servicesInjector);
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract2 scalarPanel) {
        ActionModel actionModel = this.getActionModel();
        ObjectAdapter[] pendingArguments = actionModel.getArgumentsAsArray();
        try {
            ObjectAction action = actionModel.getActionMemento().getAction(this.getSpecificationLoader());
            int numParams = action.getParameterCount();
            for (int i = 0; i < numParams; ++i) {
                PanelWithChoices panelWithChoices;
                ScalarPanelAbstract2 paramPanel = (ScalarPanelAbstract2)this.paramPanels.get(i);
                if (paramPanel == null || !(paramPanel instanceof PanelWithChoices) || !(panelWithChoices = (PanelWithChoices)((Object)paramPanel)).updateChoices(pendingArguments)) continue;
                paramPanel.repaint(target);
            }
        }
        catch (ConcurrencyException ex) {
            ObjectAdapter targetAdapter = this.getActionModel().getTargetAdapter();
            EntityPage entityPage = new EntityPage(targetAdapter, ex);
            this.setResponsePage((IRequestablePage)entityPage);
            MessageService messageService = (MessageService)this.getServicesInjector().lookupService(MessageService.class);
            messageService.warnUser(ex.getMessage());
            return;
        }
    }

    @Override
    protected FormExecutorStrategy<ActionModel> getFormExecutorStrategy() {
        ActionModel actionModel = this.getActionModel();
        return new ActionFormExecutorStrategy(actionModel);
    }
}

