/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionpromptsb;

import java.io.Serializable;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;

public class ActionPromptSidebar
extends GenericPanel<Void>
implements ActionPrompt {
    private static final long serialVersionUID = 1L;
    private ActionPrompt.CloseHandler closeHandlerIfAny;

    public ActionPromptSidebar(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{new Label(this.getTitleId(), (Serializable)((Object)"(no action)"))});
        this.add(new Component[]{new WebMarkupContainer(this.getContentId())});
    }

    public static ActionPromptSidebar newSidebar(String id) {
        return new ActionPromptSidebar(id);
    }

    public String getTitleId() {
        return "header";
    }

    public String getContentId() {
        return "content";
    }

    public void setTitle(Component titleComponent, AjaxRequestTarget target) {
        titleComponent.setMarkupId(this.getTitleId());
        this.addOrReplace(new Component[]{titleComponent});
    }

    public void setPanel(Component contentComponent, AjaxRequestTarget target) {
        contentComponent.setMarkupId(this.getContentId());
        this.addOrReplace(new Component[]{contentComponent});
    }

    public void showPrompt(AjaxRequestTarget target) {
        this.setVisible(true);
        this.show(target);
        target.add(new Component[]{this});
    }

    public void closePrompt(AjaxRequestTarget target) {
        this.setVisible(false);
        if (target != null) {
            this.hide(target);
        }
        if (this.closeHandlerIfAny != null) {
            this.closeHandlerIfAny.close(target);
        }
    }

    public void setOnClose(ActionPrompt.CloseHandler closeHandler) {
        this.closeHandlerIfAny = closeHandler;
    }

    private void show(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)"$('#wrapper').removeClass('toggled')");
    }

    private void hide(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)"$('#wrapper').addClass('toggled')");
    }
}

