/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import java.util.List;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.services.menu.MenuBarsService;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.models.ServiceActionsModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceActionUtil;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceActionsPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class ServiceActionsPanelFactory
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;

    public ServiceActionsPanelFactory() {
        super(ComponentType.SERVICE_ACTIONS, ServiceActionsPanel.class);
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof ServiceActionsModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        ServiceActionsModel serviceActionsModel = (ServiceActionsModel)model;
        DomainServiceLayout.MenuBar menuBar = serviceActionsModel.getMenuBar();
        return this.appliesIf(menuBar != DomainServiceLayout.MenuBar.TERTIARY && menuBar != null);
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        ServiceActionsModel serviceActionsModel = (ServiceActionsModel)model;
        MenuBarsService menuBarsService = (MenuBarsService)this.getIsisSessionFactory().getServicesInjector().lookupService(MenuBarsService.class);
        MenuBars menuBars = menuBarsService.menuBars();
        List<CssMenuItem> menuItems = ServiceActionUtil.buildMenu(menuBars, serviceActionsModel);
        return new ServiceActionsPanel(id, menuItems);
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

