/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.layout.component.ServiceActionLayoutData;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.layout.menubars.MenuSection;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3Menu;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBar;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ServiceActionsModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.CssClassFaBehavior;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceAndAction;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceActionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceActionUtil.class);

    private ServiceActionUtil() {
    }

    static void addLeafItem(CssMenuItem menuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        Fragment leafItem;
        if (!menuItem.isSeparator()) {
            leafItem = new Fragment("content", "leafItem", parent);
            AbstractLink subMenuItemLink = menuItem.getLink();
            Label menuItemLabel = new Label("menuLinkLabel", (Serializable)((Object)menuItem.getName()));
            subMenuItemLink.addOrReplace(new Component[]{menuItemLabel});
            listItem.add(new Behavior[]{new CssClassAppender("isis-" + CssClassAppender.asCssStyle(menuItem.getActionIdentifier()))});
            if (!menuItem.isEnabled()) {
                listItem.add(new Behavior[]{new CssClassAppender("disabled")});
                subMenuItemLink.setEnabled(false);
                TooltipBehavior tooltipBehavior = new TooltipBehavior((IModel)Model.of((Serializable)((Object)menuItem.getDisabledReason())));
                listItem.add(new Behavior[]{tooltipBehavior});
            } else {
                if (!Strings.isNullOrEmpty((String)menuItem.getDescription())) {
                    listItem.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)menuItem.getDescription())))});
                    subMenuItemLink.add(new Behavior[]{new AttributeModifier("data-original-title", (Serializable)((Object)""))});
                }
                if (menuItem.requiresImmediateConfirmation()) {
                    ServiceActionUtil.addConfirmationDialog((Component)subMenuItemLink, menuItem.getPersistenceSession().getServicesInjector());
                }
            }
            if (menuItem.isPrototyping()) {
                subMenuItemLink.add(new Behavior[]{new CssClassAppender("prototype")});
            }
            leafItem.add(new Component[]{subMenuItemLink});
            String cssClassFa = menuItem.getCssClassFa();
            if (Strings.isNullOrEmpty((String)cssClassFa)) {
                subMenuItemLink.add(new Behavior[]{new CssClassAppender("menuLinkSpacer")});
            } else {
                menuItemLabel.add(new Behavior[]{new CssClassFaBehavior(cssClassFa, menuItem.getCssClassFaPosition())});
            }
            String cssClass = menuItem.getCssClass();
            if (!Strings.isNullOrEmpty((String)cssClass)) {
                subMenuItemLink.add(new Behavior[]{new CssClassAppender(cssClass)});
            }
        } else {
            leafItem = new Fragment("content", "empty", parent);
            listItem.add(new Behavior[]{new CssClassAppender("divider")});
        }
        listItem.add(new Component[]{leafItem});
    }

    static List<CssMenuItem> withSeparators(CssMenuItem subMenuItem) {
        List<CssMenuItem> subMenuItems = subMenuItem.getSubMenuItems();
        List<CssMenuItem> cssMenuItemsWithSeparators = ServiceActionUtil.withSeparators(subMenuItems);
        subMenuItem.replaceSubMenuItems(cssMenuItemsWithSeparators);
        return cssMenuItemsWithSeparators;
    }

    static List<CssMenuItem> withSeparators(List<CssMenuItem> subMenuItems) {
        ArrayList itemsWithSeparators = Lists.newArrayList();
        for (CssMenuItem menuItem : subMenuItems) {
            if (menuItem.requiresSeparator()) {
                if (!itemsWithSeparators.isEmpty()) {
                    CssMenuItem separatorItem = CssMenuItem.newMenuItem(menuItem.getName() + "-separator").prototyping(menuItem.isPrototyping()).build();
                    separatorItem.setSeparator(true);
                    itemsWithSeparators.add(separatorItem);
                }
                menuItem.setRequiresSeparator(false);
            }
            itemsWithSeparators.add(menuItem);
        }
        return itemsWithSeparators;
    }

    static void addFolderItem(CssMenuItem subMenuItem, ListItem<CssMenuItem> listItem, final MarkupContainer parent, SeparatorStrategy separatorStrategy) {
        listItem.add(new Behavior[]{new CssClassAppender("dropdown-submenu")});
        Fragment folderItem = new Fragment("content", "folderItem", parent);
        listItem.add(new Component[]{folderItem});
        folderItem.add(new Component[]{new Label("folderName", (Serializable)((Object)subMenuItem.getName()))});
        List<CssMenuItem> menuItems = separatorStrategy.applySeparatorStrategy(subMenuItem);
        ListView<CssMenuItem> subMenuItemsView = new ListView<CssMenuItem>("subMenuItems", menuItems){

            protected void populateItem(ListItem<CssMenuItem> listItem) {
                CssMenuItem subMenuItem = (CssMenuItem)listItem.getModelObject();
                if (subMenuItem.hasSubMenuItems()) {
                    ServiceActionUtil.addFolderItem(subMenuItem, listItem, parent, SeparatorStrategy.WITHOUT_SEPARATORS);
                } else {
                    ServiceActionUtil.addLeafItem(subMenuItem, listItem, parent);
                }
            }
        };
        folderItem.add(new Component[]{subMenuItemsView});
    }

    public static List<CssMenuItem> buildMenu(MenuBars menuBars, ServiceActionsModel serviceActionsModel) {
        BS3MenuBar menuBar = (BS3MenuBar)menuBars.menuBarFor(serviceActionsModel.getMenuBar());
        List serviceAdapters = IsisContext.getSessionFactory().getCurrentSession().getPersistenceSession().getServices();
        ImmutableMap oidByServiceAdapter = FluentIterable.from((Iterable)serviceAdapters).toMap((Function)new Function<ObjectAdapter, String>(){

            public String apply(ObjectAdapter objectAdapter) {
                return objectAdapter.getOid().enStringNoVersion();
            }
        });
        ImmutableBiMap serviceAdapterByOid = ImmutableBiMap.copyOf((Map)oidByServiceAdapter).inverse();
        ArrayList menuItems = Lists.newArrayList();
        for (BS3Menu menu : menuBar.getMenus()) {
            CssMenuItem serviceMenu = CssMenuItem.newMenuItem(menu.getNamed()).build();
            for (MenuSection menuSection : menu.getSections()) {
                boolean firstSection = true;
                for (ServiceActionLayoutData actionLayoutData : menuSection.getServiceActions()) {
                    CssMenuItem.Builder subMenuItemBuilder;
                    String objectType = actionLayoutData.getObjectType();
                    Bookmark bookmark = new Bookmark(objectType, "1");
                    String oid = bookmark.toString();
                    ObjectAdapter serviceAdapter = (ObjectAdapter)serviceAdapterByOid.get((Object)oid);
                    if (serviceAdapter == null) continue;
                    EntityModel entityModel = new EntityModel(serviceAdapter);
                    ObjectAction objectAction = serviceAdapter.getSpecification().getObjectAction(actionLayoutData.getId());
                    if (objectAction == null) {
                        LOG.warn("No such action {}", (Object)actionLayoutData.getId());
                        continue;
                    }
                    ServiceAndAction serviceAndAction = new ServiceAndAction(actionLayoutData.getNamed(), entityModel, objectAction);
                    if (firstSection) {
                        serviceAndAction.separator = true;
                        firstSection = false;
                    }
                    if ((subMenuItemBuilder = serviceMenu.newSubMenuItem(serviceAndAction)) == null) continue;
                    subMenuItemBuilder.build();
                }
            }
            if (!serviceMenu.hasSubMenuItems()) continue;
            menuItems.add(serviceMenu);
        }
        return menuItems;
    }

    private static void addConfirmationDialog(Component component, ServicesInjector servicesInjector) {
        TranslationService translationService = (TranslationService)servicesInjector.lookupService(TranslationService.class);
        ConfirmationConfig confirmationConfig = new ConfirmationConfig();
        String context = IsisSessionFactoryBuilder.class.getName();
        String areYouSure = translationService.translate(context, "Are you sure?");
        String confirm = translationService.translate(context, "Confirm");
        String cancel = translationService.translate(context, "Cancel");
        confirmationConfig.withTitle(areYouSure).withBtnOkLabel(confirm).withBtnCancelLabel(cancel).withPlacement(TooltipConfig.Placement.bottom).withBtnOkClass("btn btn-danger").withBtnCancelClass("btn btn-default");
        component.add(new Behavior[]{new ConfirmationBehavior(null, confirmationConfig)});
    }

    static enum SeparatorStrategy {
        WITH_SEPARATORS{

            @Override
            List<CssMenuItem> applySeparatorStrategy(CssMenuItem subMenuItem) {
                return ServiceActionUtil.withSeparators(subMenuItem);
            }
        }
        ,
        WITHOUT_SEPARATORS{

            @Override
            List<CssMenuItem> applySeparatorStrategy(CssMenuItem subMenuItem) {
                List<CssMenuItem> subMenuItems = subMenuItem.getSubMenuItems();
                return subMenuItems;
            }
        };


        abstract List<CssMenuItem> applySeparatorStrategy(CssMenuItem var1);
    }
}

