/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ToggledMementosProvider;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionLinkFactory;

public final class LinkAndLabelUtil {
    private LinkAndLabelUtil() {
    }

    public static List<LinkAndLabel> asActionLinksForAssociation(ScalarModel scalarModelForAssociation, DeploymentCategory deploymentCategory) {
        if (scalarModelForAssociation.getKind() != ScalarModel.Kind.PROPERTY) {
            return Collections.emptyList();
        }
        EntityModel parentEntityModel = scalarModelForAssociation.getParentEntityModel();
        ObjectAdapter parentAdapter = parentEntityModel.load(AdapterManager.ConcurrencyChecking.NO_CHECK);
        OneToOneAssociation oneToOneAssociation = scalarModelForAssociation.getPropertyMemento().getProperty(scalarModelForAssociation.getSpecificationLoader());
        List associatedActions = ObjectAction.Util.findForAssociation((ObjectAdapter)parentAdapter, (ObjectAssociation)oneToOneAssociation, (DeploymentCategory)deploymentCategory);
        return LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel(parentEntityModel, associatedActions, scalarModelForAssociation);
    }

    public static List<LinkAndLabel> asActionLinksForAdditionalLinksPanel(EntityModel parentEntityModel, List<ObjectAction> objectActions, ScalarModel scalarModelForAssociationIfAny) {
        return LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel(parentEntityModel, objectActions, scalarModelForAssociationIfAny, null);
    }

    public static List<LinkAndLabel> asActionLinksForAdditionalLinksPanel(EntityModel parentEntityModel, List<ObjectAction> objectActions, ScalarModel scalarModelForAssociationIfAny, final ToggledMementosProvider toggledMementosProviderIfAny) {
        final EntityActionLinkFactory linkFactory = new EntityActionLinkFactory(parentEntityModel, scalarModelForAssociationIfAny);
        return FluentIterable.from(objectActions).transform((Function)new Function<ObjectAction, LinkAndLabel>(){

            public LinkAndLabel apply(ObjectAction objectAction) {
                return linkFactory.newLink(objectAction, "additionalLink", toggledMementosProviderIfAny);
            }
        }).filter(Predicates.notNull()).toList();
    }
}

