/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.about;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.isis.core.commons.lang.CloseableExtensions;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;
import org.apache.isis.viewer.wicket.ui.components.about.JarManifestAttributes;

public class JarManifestModel
extends ModelAbstract<JarManifestModel> {
    private static final long serialVersionUID = 1L;
    private static final List<String> VERSION_KEY_CANDIDATES = Arrays.asList("Implementation-Version", "Build-Time");
    private final List<JarManifestAttributes> manifests = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarManifestModel(InputStream metaInfManifestIs) {
        Enumeration<URL> resEnum;
        Manifest manifest;
        try {
            manifest = new Manifest(metaInfManifestIs);
            this.manifests.add(JarManifestAttributes.jarName("Web archive (war file)"));
            this.manifests.add(JarManifestAttributes.jarUrl(null));
            JarManifestModel.addAttributes(manifest, this.manifests);
        }
        catch (Exception exception) {
        }
        finally {
            CloseableExtensions.closeSafely((Closeable)metaInfManifestIs);
        }
        try {
            resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            return;
        }
        ArrayList jarManifests = Lists.newArrayList();
        while (resEnum.hasMoreElements()) {
            URL url = resEnum.nextElement();
            JarManifest jarManifest = new JarManifest(url);
            jarManifests.add(jarManifest);
            InputStream is = null;
            try {
                is = url.openStream();
                if (is == null) continue;
                manifest = new Manifest(is);
                jarManifest.addAttributesFrom(manifest);
            }
            catch (Exception exception) {}
            continue;
            finally {
                CloseableExtensions.closeSafely((Closeable)is);
            }
        }
        Collections.sort(jarManifests);
        for (JarManifest jarManifest : jarManifests) {
            jarManifest.addAttributesTo(this.manifests);
        }
    }

    private static JarName asJarName(URL url) {
        String path = url.getPath();
        String strippedPath = JarManifestModel.stripSuffix(path, "/META-INF/MANIFEST.MF");
        strippedPath = JarManifestModel.stripSuffix(strippedPath, "!");
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"/\\")).split((CharSequence)strippedPath));
        Collections.reverse(parts);
        for (String part : parts) {
            if (!part.endsWith(".jar")) continue;
            return new JarName(JarName.Type.JAR, part);
        }
        if (parts.size() >= 3 && ((String)parts.get(0)).equals("classes") && ((String)parts.get(1)).startsWith("target")) {
            return new JarName(JarName.Type.CLASSES, (String)parts.get(2));
        }
        return new JarName(JarName.Type.OTHER, strippedPath);
    }

    public static String stripSuffix(String path, String suffix) {
        int indexOf = path.indexOf(suffix);
        if (indexOf != -1) {
            path = path.substring(0, indexOf);
        }
        return path;
    }

    static void addAttributes(Manifest manifest, List<JarManifestAttributes> attributes) {
        Attributes mainAttribs = manifest.getMainAttributes();
        Set<Map.Entry<Object, Object>> entrySet = mainAttribs.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            JarManifestAttributes attribute = JarManifestAttributes.attribute(entry);
            attributes.add(attribute);
        }
    }

    protected JarManifestModel load() {
        return this;
    }

    public void setObject(JarManifestModel ex) {
    }

    public List<JarManifestAttributes> getDetail() {
        return this.manifests;
    }

    static class JarName
    implements Comparable<JarName> {
        Type type;
        String name;

        JarName(Type type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public int compareTo(JarName o) {
            int x = this.type.compareTo(o.type);
            if (x != 0) {
                return x;
            }
            return this.name.compareTo(o.name);
        }

        static enum Type {
            CLASSES,
            JAR,
            OTHER;

        }
    }

    private static class JarManifest
    implements Comparable<JarManifest> {
        private final List<JarManifestAttributes> attributes = Lists.newArrayList();
        private final URL url;
        private JarName jarName;

        public JarManifest(URL url) {
            this.url = url;
            this.jarName = JarManifestModel.asJarName(url);
        }

        void addAttributesFrom(Manifest manifest) {
            JarManifestModel.addAttributes(manifest, this.attributes);
        }

        void addAttributesTo(List<JarManifestAttributes> manifests) {
            manifests.add(JarManifestAttributes.jarName(this.jarName.name));
            manifests.add(JarManifestAttributes.jarUrl(this.url));
            manifests.addAll(this.attributes);
        }

        @Override
        public int compareTo(JarManifest o) {
            return this.jarName.compareTo(o.jarName);
        }
    }
}

