/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.upcasting;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.Serializer;
import org.axonframework.upcasting.AbstractUpcasterChain;
import org.axonframework.upcasting.Upcaster;
import org.axonframework.upcasting.UpcastingContext;

public class LazyUpcasterChain
extends AbstractUpcasterChain {
    public LazyUpcasterChain(List<Upcaster> upcasters) {
        this(new ChainingConverterFactory(), upcasters);
    }

    public LazyUpcasterChain(Serializer serializer, List<Upcaster> upcasters) {
        super(serializer.getConverterFactory(), upcasters);
    }

    public LazyUpcasterChain(ConverterFactory converterFactory, List<Upcaster> upcasters) {
        super(converterFactory, upcasters);
    }

    @Override
    protected <T> List<SerializedObject<?>> doUpcast(Upcaster<T> upcaster, SerializedObject<?> sourceObject, List<SerializedType> targetTypes, UpcastingContext context) {
        LazyUpcastObject<T> lazyUpcastObject = new LazyUpcastObject<T>(sourceObject, targetTypes, upcaster, context);
        ArrayList upcastObjects = new ArrayList(targetTypes.size());
        int t = 0;
        for (SerializedType serializedType : targetTypes) {
            upcastObjects.add(new LazyUpcastingSerializedObject<T>(t, lazyUpcastObject, serializedType));
            ++t;
        }
        return upcastObjects;
    }

    private static class LazyUpcastingSerializedObject<T>
    implements SerializedObject {
        private final int index;
        private final LazyUpcastObject<T> lazyUpcastObject;
        private final SerializedType type;

        public LazyUpcastingSerializedObject(int index, LazyUpcastObject<T> lazyUpcastObject, SerializedType type) {
            this.index = index;
            this.lazyUpcastObject = lazyUpcastObject;
            this.type = type;
        }

        public Class<?> getContentType() {
            return this.lazyUpcastObject.getUpcastSerializedObjects().get(this.index).getContentType();
        }

        @Override
        public SerializedType getType() {
            return this.type;
        }

        public Object getData() {
            return this.lazyUpcastObject.getUpcastSerializedObjects().get(this.index).getData();
        }
    }

    private class LazyUpcastObject<T> {
        private final SerializedObject<?> serializedObject;
        private final List<SerializedType> upcastTypes;
        private final Upcaster<T> currentUpcaster;
        private volatile List<SerializedObject<?>> upcastObjects = null;
        private final UpcastingContext properties;

        public LazyUpcastObject(SerializedObject<?> serializedObject, List<SerializedType> upcastTypes, Upcaster<T> currentUpcaster, UpcastingContext properties) {
            this.serializedObject = serializedObject;
            this.upcastTypes = upcastTypes;
            this.currentUpcaster = currentUpcaster;
            this.properties = properties;
        }

        public List<SerializedObject<?>> getUpcastSerializedObjects() {
            if (this.upcastObjects == null) {
                SerializedObject<T> converted = LazyUpcasterChain.this.ensureCorrectContentType(this.serializedObject, this.currentUpcaster.expectedRepresentationType());
                this.upcastObjects = this.currentUpcaster.upcast(converted, this.upcastTypes, this.properties);
            }
            return this.upcastObjects;
        }
    }
}

