/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.upcasting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.axonframework.common.Assert;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ContentTypeConverter;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.upcasting.ExtendedUpcaster;
import org.axonframework.upcasting.Upcaster;
import org.axonframework.upcasting.UpcasterChain;
import org.axonframework.upcasting.UpcastingContext;

public abstract class AbstractUpcasterChain
implements UpcasterChain {
    private final List<Upcaster> upcasters;
    private final ConverterFactory converterFactory;

    protected AbstractUpcasterChain(List<Upcaster> upcasters) {
        this(new ChainingConverterFactory(), upcasters);
    }

    protected AbstractUpcasterChain(ConverterFactory converterFactory, List<Upcaster> upcasters) {
        Assert.notNull(converterFactory, "converterFactory may not be null");
        this.upcasters = upcasters;
        this.converterFactory = converterFactory;
    }

    @Override
    public List<SerializedObject> upcast(SerializedObject serializedObject, UpcastingContext upcastingContext) {
        if (this.upcasters.isEmpty()) {
            return Collections.singletonList(serializedObject);
        }
        Iterator<Upcaster> upcasterIterator = this.upcasters.iterator();
        return this.upcastInternal(Collections.singletonList(serializedObject), upcasterIterator, upcastingContext);
    }

    protected <S, T> SerializedObject<T> ensureCorrectContentType(SerializedObject<S> serializedObject, Class<T> expectedContentType) {
        if (!expectedContentType.isAssignableFrom(serializedObject.getContentType())) {
            ContentTypeConverter<SerializedObject<S>, T> converter = this.converterFactory.getConverter(serializedObject.getContentType(), expectedContentType);
            return converter.convert(serializedObject);
        }
        return serializedObject;
    }

    protected abstract <T> List<SerializedObject<?>> doUpcast(Upcaster<T> var1, SerializedObject<?> var2, List<SerializedType> var3, UpcastingContext var4);

    private List<SerializedObject> upcastInternal(List<SerializedObject> serializedObjects, Iterator<Upcaster> upcasterIterator, UpcastingContext context) {
        if (!upcasterIterator.hasNext()) {
            return serializedObjects;
        }
        ArrayList<SerializedObject> upcastObjects = new ArrayList<SerializedObject>();
        Upcaster currentUpcaster = upcasterIterator.next();
        for (SerializedObject serializedObject : serializedObjects) {
            if (currentUpcaster.canUpcast(serializedObject.getType())) {
                List<SerializedType> upcastTypes = currentUpcaster instanceof ExtendedUpcaster ? ((ExtendedUpcaster)currentUpcaster).upcast(serializedObject.getType(), serializedObject) : currentUpcaster.upcast(serializedObject.getType());
                upcastObjects.addAll(this.doUpcast(currentUpcaster, serializedObject, upcastTypes, context));
                continue;
            }
            upcastObjects.add(serializedObject);
        }
        return this.upcastInternal(upcastObjects, upcasterIterator, context);
    }
}

