/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.unitofwork;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.EventMessage;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitOfWorkListenerCollection
implements UnitOfWorkListener {
    private static final Logger logger = LoggerFactory.getLogger(UnitOfWorkListenerCollection.class);
    private final Deque<UnitOfWorkListener> listeners = new ArrayDeque<UnitOfWorkListener>();

    @Override
    public void afterCommit(UnitOfWork unitOfWork) {
        logger.debug("Notifying listeners after commit");
        Iterator<UnitOfWorkListener> descendingIterator = this.listeners.descendingIterator();
        while (descendingIterator.hasNext()) {
            UnitOfWorkListener listener = descendingIterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying listener [{}] after commit", (Object)listener.getClass().getName());
            }
            listener.afterCommit(unitOfWork);
        }
    }

    @Override
    public void onRollback(UnitOfWork unitOfWork, Throwable failureCause) {
        logger.debug("Notifying listeners of rollback");
        Iterator<UnitOfWorkListener> descendingIterator = this.listeners.descendingIterator();
        while (descendingIterator.hasNext()) {
            UnitOfWorkListener listener = descendingIterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying listener [{}] of rollback", (Object)listener.getClass().getName());
            }
            listener.onRollback(unitOfWork, failureCause);
        }
    }

    @Override
    public <T> EventMessage<T> onEventRegistered(UnitOfWork unitOfWork, EventMessage<T> event) {
        EventMessage<T> newEvent = event;
        for (UnitOfWorkListener listener : this.listeners) {
            newEvent = listener.onEventRegistered(unitOfWork, newEvent);
        }
        return newEvent;
    }

    @Override
    public void onPrepareCommit(UnitOfWork unitOfWork, Set<AggregateRoot> aggregateRoots, List<EventMessage> events) {
        logger.debug("Notifying listeners of commit request");
        for (UnitOfWorkListener listener : this.listeners) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying listener [{}] of upcoming commit", (Object)listener.getClass().getName());
            }
            listener.onPrepareCommit(unitOfWork, aggregateRoots, events);
        }
        logger.debug("Listeners successfully notified");
    }

    @Override
    public void onPrepareTransactionCommit(UnitOfWork unitOfWork, Object transaction) {
        logger.debug("Notifying listeners of transaction commit request");
        for (UnitOfWorkListener listener : this.listeners) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying listener [{}] of upcoming transaction commit", (Object)listener.getClass().getName());
            }
            listener.onPrepareTransactionCommit(unitOfWork, transaction);
        }
        logger.debug("Listeners successfully notified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCleanup(UnitOfWork unitOfWork) {
        try {
            logger.debug("Notifying listeners of cleanup");
            Iterator<UnitOfWorkListener> descendingIterator = this.listeners.descendingIterator();
            while (descendingIterator.hasNext()) {
                UnitOfWorkListener listener = descendingIterator.next();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Notifying listener [{}] of cleanup", (Object)listener.getClass().getName());
                    }
                    listener.onCleanup(unitOfWork);
                }
                catch (RuntimeException e) {
                    logger.warn("Listener raised an exception on cleanup. Ignoring...", (Throwable)e);
                }
            }
            logger.debug("Listeners successfully notified");
        }
        finally {
            this.listeners.clear();
        }
    }

    public void add(UnitOfWorkListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering listener: {}", (Object)listener.getClass().getName());
        }
        this.listeners.add(listener);
    }
}

