/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.unitofwork;

import org.axonframework.common.Assert;
import org.axonframework.unitofwork.TransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransactionManager
implements TransactionManager<TransactionStatus> {
    private PlatformTransactionManager transactionManager;
    private TransactionDefinition transactionDefinition;

    public SpringTransactionManager(PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        Assert.notNull(transactionManager, "transactionManager may not be null");
        this.transactionManager = transactionManager;
        this.transactionDefinition = transactionDefinition;
    }

    public SpringTransactionManager(PlatformTransactionManager transactionManager) {
        this(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition());
    }

    public SpringTransactionManager() {
        this.transactionDefinition = new DefaultTransactionDefinition();
    }

    @Override
    public TransactionStatus startTransaction() {
        return this.transactionManager.getTransaction(this.transactionDefinition);
    }

    @Override
    public void commitTransaction(TransactionStatus tx) {
        if (tx.isNewTransaction() && !tx.isCompleted()) {
            this.transactionManager.commit(tx);
        }
    }

    @Override
    public void rollbackTransaction(TransactionStatus tx) {
        if (tx.isNewTransaction() && !tx.isCompleted()) {
            this.transactionManager.rollback(tx);
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }
}

