/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.unitofwork;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;
import org.joda.time.DateTime;

public abstract class MetaDataMutatingUnitOfWorkListenerAdapter
extends UnitOfWorkListenerAdapter {
    @Override
    public final <T> EventMessage<T> onEventRegistered(UnitOfWork unitOfWork, EventMessage<T> event) {
        return this.wrapped(event);
    }

    @Override
    public void onPrepareCommit(UnitOfWork unitOfWork, Set<AggregateRoot> aggregateRoots, List<EventMessage> events) {
        int i = 0;
        for (EventMessage event : events) {
            EventMessage changedEvent;
            Map<String, ?> additionalMetaData = this.assignMetaData(event, events, i++);
            if (additionalMetaData == null || !((changedEvent = event.andMetaData(additionalMetaData)) instanceof MutableEventMessage)) continue;
            ((MutableEventMessage)changedEvent).makeImmutable();
        }
    }

    protected abstract Map<String, ?> assignMetaData(EventMessage var1, List<EventMessage> var2, int var3);

    private <T> EventMessage<T> wrapped(EventMessage<T> event) {
        if (event instanceof DomainEventMessage) {
            return new MutableDomainEventMessage((DomainEventMessage)event);
        }
        return new MutableEventMessage<T>(event);
    }

    private static class MutableDomainEventMessage<T>
    extends MutableEventMessage<T>
    implements DomainEventMessage<T> {
        private static final long serialVersionUID = -1814502500382189837L;

        public MutableDomainEventMessage(DomainEventMessage<T> event) {
            super(event);
        }

        @Override
        public long getSequenceNumber() {
            return this.getWrappedEvent().getSequenceNumber();
        }

        @Override
        public Object getAggregateIdentifier() {
            return this.getWrappedEvent().getAggregateIdentifier();
        }

        @Override
        protected DomainEventMessage<T> getWrappedEvent() {
            return (DomainEventMessage)super.getWrappedEvent();
        }

        @Override
        public DomainEventMessage<T> withMetaData(Map<String, ?> metaData) {
            return (DomainEventMessage)super.withMetaData((Map)metaData);
        }

        @Override
        public DomainEventMessage<T> andMetaData(Map<String, ?> additionalMetaData) {
            return (DomainEventMessage)super.andMetaData((Map)additionalMetaData);
        }
    }

    private static class MutableEventMessage<T>
    implements EventMessage<T> {
        private static final long serialVersionUID = -5697283646053267959L;
        private final EventMessage<T> event;
        private volatile MetaData metaData;
        private volatile boolean fixed;

        public MutableEventMessage(EventMessage<T> event) {
            this.event = event;
            this.metaData = event.getMetaData();
        }

        @Override
        public String getIdentifier() {
            return this.event.getIdentifier();
        }

        @Override
        public MetaData getMetaData() {
            return this.metaData;
        }

        @Override
        public T getPayload() {
            return this.event.getPayload();
        }

        @Override
        public Class getPayloadType() {
            return this.event.getPayloadType();
        }

        @Override
        public DateTime getTimestamp() {
            return this.event.getTimestamp();
        }

        @Override
        public EventMessage<T> withMetaData(Map<String, ?> metaData) {
            if (this.fixed) {
                return this.event.withMetaData(metaData);
            }
            this.metaData = new MetaData(metaData);
            return this;
        }

        @Override
        public EventMessage<T> andMetaData(Map<String, ?> additionalMetaData) {
            if (this.fixed) {
                return this.event.withMetaData(this.metaData).andMetaData(additionalMetaData);
            }
            HashMap newMetaData = new HashMap(additionalMetaData);
            newMetaData.putAll(this.metaData);
            this.metaData = new MetaData(newMetaData);
            return this;
        }

        protected EventMessage<T> getWrappedEvent() {
            return this.event;
        }

        protected Object writeReplace() {
            return this.event.withMetaData(this.metaData);
        }

        public void makeImmutable() {
            this.fixed = true;
        }
    }
}

