/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.unitofwork;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.EventRegistrationCallback;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.unitofwork.NestableUnitOfWork;
import org.axonframework.unitofwork.SaveAggregateCallback;
import org.axonframework.unitofwork.TransactionManager;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListener;
import org.axonframework.unitofwork.UnitOfWorkListenerCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnitOfWork
extends NestableUnitOfWork {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUnitOfWork.class);
    private final Map<AggregateRoot, AggregateEntry> registeredAggregates = new LinkedHashMap<AggregateRoot, AggregateEntry>();
    private final Map<EventBus, List<EventMessage<?>>> eventsToPublish = new HashMap();
    private final UnitOfWorkListenerCollection listeners = new UnitOfWorkListenerCollection();
    private Status dispatcherStatus = Status.READY;
    private final TransactionManager transactionManager;
    private Object backingTransaction;

    public DefaultUnitOfWork() {
        this(null);
    }

    public DefaultUnitOfWork(TransactionManager<?> transactionManager) {
        this.transactionManager = transactionManager;
    }

    public static UnitOfWork startAndGet() {
        DefaultUnitOfWork uow = new DefaultUnitOfWork();
        uow.start();
        return uow;
    }

    public static UnitOfWork startAndGet(TransactionManager<?> transactionManager) {
        DefaultUnitOfWork uow = new DefaultUnitOfWork(transactionManager);
        uow.start();
        return uow;
    }

    @Override
    protected void doStart() {
        if (this.isTransactional()) {
            this.backingTransaction = this.transactionManager.startTransaction();
        }
    }

    @Override
    public boolean isTransactional() {
        return this.transactionManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRollback(Throwable cause) {
        this.registeredAggregates.clear();
        this.eventsToPublish.clear();
        try {
            if (this.backingTransaction != null) {
                this.transactionManager.rollbackTransaction(this.backingTransaction);
            }
        }
        finally {
            this.notifyListenersRollback(cause);
        }
    }

    @Override
    protected void doCommit() {
        do {
            this.publishEvents();
            this.commitInnerUnitOfWork();
        } while (!this.eventsToPublish.isEmpty());
        if (this.isTransactional()) {
            this.notifyListenersPrepareTransactionCommit(this.backingTransaction);
            this.transactionManager.commitTransaction(this.backingTransaction);
        }
        this.notifyListenersAfterCommit();
    }

    @Override
    protected void registerScheduledEvents(UnitOfWork unitOfWork) {
        for (Map.Entry<EventBus, List<EventMessage<?>>> entry : this.eventsToPublish.entrySet()) {
            for (EventMessage<?> eventMessage : entry.getValue()) {
                unitOfWork.publishEvent(eventMessage, entry.getKey());
            }
        }
        this.eventsToPublish.clear();
    }

    @Override
    public <T extends AggregateRoot> T registerAggregate(T aggregate, EventBus eventBus, SaveAggregateCallback<T> saveAggregateCallback) {
        Object similarAggregate = this.findSimilarAggregate(aggregate.getClass(), aggregate.getIdentifier());
        if (similarAggregate != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Ignoring aggregate registration. An aggregate of same type and identifier was already registered in this Unit Of Work: type [{}], identifier [{}]", (Object)aggregate.getClass().getSimpleName(), aggregate.getIdentifier());
            }
            return (T)similarAggregate;
        }
        UoWEventRegistrationCallback eventRegistrationCallback = new UoWEventRegistrationCallback(eventBus);
        this.registeredAggregates.put(aggregate, new AggregateEntry<T>(aggregate, saveAggregateCallback));
        aggregate.addEventRegistrationCallback(eventRegistrationCallback);
        return aggregate;
    }

    private <T> EventMessage<T> invokeEventRegistrationListeners(EventMessage<T> event) {
        return this.listeners.onEventRegistered(this, event);
    }

    private <T extends AggregateRoot> T findSimilarAggregate(Class<T> aggregateType, Object identifier) {
        for (AggregateRoot aggregate : this.registeredAggregates.keySet()) {
            if (!aggregateType.isInstance(aggregate) || !identifier.equals(aggregate.getIdentifier())) continue;
            return (T)aggregate;
        }
        return null;
    }

    @Override
    public void registerListener(UnitOfWorkListener listener) {
        this.listeners.add(listener);
    }

    private List<EventMessage<?>> eventsToPublishOn(EventBus eventBus) {
        if (!this.eventsToPublish.containsKey(eventBus)) {
            this.eventsToPublish.put(eventBus, new ArrayList());
        }
        return this.eventsToPublish.get(eventBus);
    }

    @Override
    public void registerForPublication(EventMessage<?> event, EventBus eventBus, boolean notifyRegistrationHandlers) {
        if (logger.isDebugEnabled()) {
            logger.debug("Staging event for publishing: [{}] on [{}]", (Object)event.getPayloadType().getName(), (Object)eventBus.getClass().getName());
        }
        if (notifyRegistrationHandlers) {
            event = this.invokeEventRegistrationListeners(event);
        }
        this.eventsToPublishOn(eventBus).add(event);
    }

    @Override
    protected void notifyListenersRollback(Throwable cause) {
        this.listeners.onRollback(this, cause);
    }

    protected void notifyListenersPrepareTransactionCommit(Object transaction) {
        this.listeners.onPrepareTransactionCommit(this, transaction);
    }

    protected void notifyListenersAfterCommit() {
        this.listeners.afterCommit(this);
    }

    protected void publishEvents() {
        logger.debug("Publishing events to the event bus");
        if (this.dispatcherStatus == Status.DISPATCHING) {
            logger.debug("UnitOfWork is already in the dispatch process. That process will publish events instead. Aborting...");
            return;
        }
        this.dispatcherStatus = Status.DISPATCHING;
        while (!this.eventsToPublish.isEmpty()) {
            Iterator<Map.Entry<EventBus, List<EventMessage<?>>>> iterator = this.eventsToPublish.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<EventBus, List<EventMessage<?>>> entry = iterator.next();
                List<EventMessage<?>> messageList = entry.getValue();
                EventMessage[] messages = messageList.toArray(new EventMessage[messageList.size()]);
                if (logger.isDebugEnabled()) {
                    for (EventMessage message : messages) {
                        logger.debug("Publishing event [{}] to event bus [{}]", (Object)message.getPayloadType().getName(), (Object)entry.getKey());
                    }
                }
                iterator.remove();
                entry.getKey().publish(messages);
            }
        }
        logger.debug("All events successfully published.");
        this.dispatcherStatus = Status.READY;
    }

    @Override
    protected void saveAggregates() {
        logger.debug("Persisting changes to aggregates");
        for (AggregateEntry entry : this.registeredAggregates.values()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Persisting changes to [{}], identifier: [{}]", (Object)entry.aggregateRoot.getClass().getName(), entry.aggregateRoot.getIdentifier());
            }
            entry.saveAggregate();
        }
        logger.debug("Aggregates successfully persisted");
        this.registeredAggregates.clear();
    }

    @Override
    protected void notifyListenersPrepareCommit() {
        this.listeners.onPrepareCommit(this, this.registeredAggregates.keySet(), this.eventsToPublish());
    }

    @Override
    protected void notifyListenersCleanup() {
        this.listeners.onCleanup(this);
    }

    private List<EventMessage> eventsToPublish() {
        ArrayList events = new ArrayList();
        for (Map.Entry<EventBus, List<EventMessage<?>>> entry : this.eventsToPublish.entrySet()) {
            events.addAll(entry.getValue());
        }
        return Collections.unmodifiableList(events);
    }

    private class UoWEventRegistrationCallback
    implements EventRegistrationCallback {
        private final EventBus eventBus;

        public UoWEventRegistrationCallback(EventBus eventBus) {
            this.eventBus = eventBus;
        }

        @Override
        public <T> DomainEventMessage<T> onRegisteredEvent(DomainEventMessage<T> event) {
            event = (DomainEventMessage)DefaultUnitOfWork.this.invokeEventRegistrationListeners(event);
            DefaultUnitOfWork.this.eventsToPublishOn(this.eventBus).add(event);
            return event;
        }
    }

    private static class AggregateEntry<T extends AggregateRoot> {
        private final T aggregateRoot;
        private final SaveAggregateCallback<T> callback;

        public AggregateEntry(T aggregateRoot, SaveAggregateCallback<T> callback) {
            this.aggregateRoot = aggregateRoot;
            this.callback = callback;
        }

        public void saveAggregate() {
            this.callback.save(this.aggregateRoot);
        }
    }

    private static enum Status {
        READY,
        DISPATCHING;

    }
}

