/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.axonframework.serializer.AbstractContentTypeConverter;
import org.axonframework.serializer.CannotConvertBetweenTypesException;

public class JsonNodeToByteArrayConverter
extends AbstractContentTypeConverter<JsonNode, byte[]> {
    private final ObjectMapper objectMapper;

    public JsonNodeToByteArrayConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Class<JsonNode> expectedSourceType() {
        return JsonNode.class;
    }

    @Override
    public Class<byte[]> targetType() {
        return byte[].class;
    }

    @Override
    public byte[] convert(JsonNode original) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)original);
        }
        catch (JsonProcessingException e) {
            throw new CannotConvertBetweenTypesException("An error occurred while converting a JsonNode to byte[]", e);
        }
    }
}

