/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.serializer.SerializationException;

public class JodaDeserializer<T>
extends JsonDeserializer<T> {
    private final Constructor<T> constructor;

    public JodaDeserializer(Class<T> instantType) {
        try {
            this.constructor = instantType.getConstructor(Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AxonConfigurationException("The type " + instantType.getName() + " isn't compatible with the JodaDeserializer", e);
        }
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        try {
            return this.constructor.newInstance(jp.readValueAs(String.class));
        }
        catch (Exception e) {
            throw new SerializationException("Unable to read instant from JSON document", e);
        }
    }
}

